
ALTER TABLE `invt_student_distribution` 
ADD COLUMN `entryType` VARCHAR(45) NULL AFTER `POD`,
ADD COLUMN `itemCategoryId` BIGINT(20) NULL AFTER `entryType`,
ADD COLUMN `outwardNo` VARCHAR(255) NULL AFTER `itemCategoryId`,
ADD COLUMN `senderContactNo` VARCHAR(15) NULL DEFAULT NULL AFTER `outwardNo`,
ADD COLUMN `deliverTo` VARCHAR(255) NULL DEFAULT NULL AFTER `senderContactNo`,
ADD COLUMN `receiverContactNo` VARCHAR(15) NULL DEFAULT NULL AFTER `deliverTo`,
ADD COLUMN `entryBy` BIGINT(20) NULL DEFAULT NULL AFTER `receiverContactNo`,
ADD COLUMN `noOfPackets` INT(11) NULL DEFAULT NULL AFTER `entryBy`,
ADD COLUMN `isItemInsured` BIT(1) NULL DEFAULT NULL AFTER `noOfPackets`,
ADD COLUMN `insuredById` BIGINT(20) NULL DEFAULT NULL AFTER `isItemInsured`,
ADD COLUMN `policyNo` VARCHAR(255) NULL DEFAULT NULL AFTER `insuredById`,
ADD COLUMN `insuranceAmount` DOUBLE NULL DEFAULT NULL AFTER `policyNo`,
ADD COLUMN `receivedBy` VARCHAR(255) NULL DEFAULT NULL AFTER `insuranceAmount`,
ADD COLUMN `returnReason` TEXT NULL DEFAULT NULL AFTER `receivedBy`;

ALTER TABLE `invt_student_distribution` 
ADD INDEX `fk_invt_student_distribution_itemCategoryId_idx` (`itemCategoryId` ASC),
ADD INDEX `fk_invt_student_distribution_insuredById_idx` (`insuredById` ASC),
ADD INDEX `fk_invt_student_distribution_deliverTo_idx` (`deliverTo` ASC),
ADD INDEX `fk_invt_student_distribution_entryBy_idx` (`entryBy` ASC);

ALTER TABLE `invt_student_distribution` 
ADD CONSTRAINT `fk_invt_student_distribution_itemCategoryId`
  FOREIGN KEY (`itemCategoryId`)
  REFERENCES `invt_type_master` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_invt_student_distribution_entryBy`
  FOREIGN KEY (`entryBy`)
  REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_invt_student_distribution_insuredById`
  FOREIGN KEY (`insuredById`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;