CREATE TABLE `program_group_details` (
  `id` BIGINT(20) NOT NULL,
  `programGroupId` BIGINT(20) NULL,
  `academyLocationId` BIGINT(20) NULL,
  `eMISNumber` VARCHAR(45) NULL,
  `countryRegionId` BIGINT(20) NULL,
  `logoPath` VARCHAR(45) NULL,
  `isBoardingSchool` BIT(1) NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_program_group_details_1_idx` (`programGroupId` ASC),
  INDEX `fk_program_group_details_2_idx` (`academyLocationId` ASC),
  INDEX `fk_program_group_details_3_idx` (`countryRegionId` ASC),
  CONSTRAINT `fk_program_group_details_1`
    FOREIGN KEY (`programGroupId`)
    REFERENCES `program_group` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_program_group_details_2`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_program_group_details_3`
    FOREIGN KEY (`countryRegionId`)
    REFERENCES `country_region` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

CREATE TABLE `program_group_addresses` (
  `id` bigint(20) NOT NULL,
  `addressId` bigint(20) DEFAULT NULL,
  `programGroupId` bigint(20) DEFAULT NULL,
   `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_program_addresses_1_idx` (`addressId`),
  KEY `fk_program_user_id_idx` (`lastUpdatedBy`),
  KEY `fk_program_group_addresses_2_idx` (`programGroupId`),
  CONSTRAINT `fk_program_addresses_1` FOREIGN KEY (`addressId`) REFERENCES `address` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_program_group_addresses_2` FOREIGN KEY (`programGroupId`) REFERENCES `program_group` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_program_user_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1