CREATE TABLE `campaign_school_priority_mapping` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `intakeYearId` bigint(20) DEFAULT NULL,
  `campaignSchoolId` bigint(20) DEFAULT NULL,
  `schoolPriority` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_campaign_school_priority_mapping_campaignSchoolId_idx` (`campaignSchoolId`),
  KEY `fk_campaign_school_priority_mapping_lastUpdatedBy_idx` (`lastUpdatedBy`),
  KEY `fk_campaign_school_priority_mapping_intakeYearId_idx` (`intakeYearId`),
  KEY `fk_campaign_school_priority_mapping_academyLocationId_idx` (`academyLocationId`),
  CONSTRAINT `fk_campaign_school_priority_mapping_academyLocationId` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_campaign_school_priority_mapping_intakeYearId` FOREIGN KEY (`intakeYearId`) REFERENCES `intake_year` (`id`),
  CONSTRAINT `fk_campaign_school_priority_mapping_campaignSchoolId` FOREIGN KEY (`campaignSchoolId`) REFERENCES `campaign_school` (`id`),
  CONSTRAINT `fk_campaign_school_priority_mapping_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;