DROP procedure IF EXISTS `delete_student`;

DELIMITER $$

CREATE PROCEDURE `delete_student`(studentIds varchar(21844))
BEGIN
	
select now();
SET SQL_SAFE_UPDATES=0;
SET FOREIGN_KEY_CHECKS=0;
SET SESSION group_concat_max_len = 1000000;

create temporary table if not exists templog_deletedStudentRecords (recordDeleted varchar(5120));
truncate table templog_deletedStudentRecords;

set @sql = concat("SELECT group_concat(distinct students.personId) into @personID from students 
where students.userId IN (",studentIds,")");
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values(concat('V1:@personID:=', @personID));

set @sql = concat("SELECT group_concat(distinct admission.id) into @admissionID from admission 
where admission.studentId IN (",studentIds,")");
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values(concat('V2:@admissionID:=', @admissionID));

set @sql = concat("SELECT group_concat(distinct admission.applicationAdmissionId) into @applicationAdmDetailsId from admission 
where admission.studentId IN (",studentIds,")");
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values(concat('V3:@applicationAdmDetailsId:=', @applicationAdmDetailsId));


set @sql = concat("SELECT group_concat(distinct user_academy_locations.id) into @userALID 
from user_academy_locations where user_academy_locations.userId IN (",studentIds,")");
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values(concat('V4:@userALID:=', @userALID));

set @sql = concat("DELETE FROM prog_batch_course_details where prog_batch_course_details.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;    
insert into templog_deletedStudentRecords values('1:prog_batch_course_details');

set @sql = concat("DELETE FROM student_course_enrollment where student_course_enrollment.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('2:student_course_enrollment');


set @sql = concat("DELETE from promotion where fromRecordId IN (
SELECT id FROM program_batch_students where program_batch_students.admissionId IN (" , @admissionID , "))");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('3:promotion');


set @sql = concat("DELETE FROM program_batch_students where program_batch_students.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('4:program_batch_students');


set @sql = concat("DELETE FROM marksheet_job_details where marksheet_job_details.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('5:marksheet_job_details');

set @sql = concat("DELETE FROM marksheet where marksheet.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('6:marksheet');

set @sql = concat("DELETE FROM examination_repetition where examination_repetition.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('7:examination_repetition');

set @sql = concat("DELETE FROM evaluation_program_rank where evaluation_program_rank.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('8:evaluation_program_rank');

set @sql = concat("DELETE FROM evaluation_period_rank where evaluation_period_rank.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('9:evaluation_period_rank');

set @sql = concat("DELETE FROM evaluation_plan_rank where evaluation_plan_rank.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('10:evaluation_plan_rank');

set @sql = concat("DELETE FROM evaluation_plan_level_one_rank where evaluation_plan_level_one_rank.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('11:evaluation_plan_level_one_rank');

set @sql = concat("DELETE FROM evaluation_plan_level_two_rank where evaluation_plan_level_two_rank.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('12:evaluation_plan_level_two_rank');

set @sql = concat("DELETE FROM evaluation_sequence_rank where evaluation_sequence_rank.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('13:evaluation_sequence_rank');

set @sql = concat("DELETE FROM examination_result_history where examination_result_history.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('14:examination_result_history');

set @sql = concat("DELETE FROM examination_result where examination_result.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('15:examination_result');

set @sql = concat("DELETE FROM evaluation_group_applicant_document where evaluation_group_applicant_document.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('16:evaluation_group_applicant_document');

set @sql = concat("DELETE FROM evaluation_group_applicant where evaluation_group_applicant.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('17:evaluation_group_applicant');

set @sql = concat("DELETE FROM evaluation_plan_students where evaluation_plan_students.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('18:evaluation_plan_students');

set @sql = concat("DELETE FROM evaluation_student_remark where evaluation_student_remark.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('19:evaluation_student_remark');

set @sql = concat("DELETE FROM exam_timeslot where exam_timeslot.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('20:exam_timeslot');

set @sql = concat("DELETE FROM evaluation_student_remark where evaluation_student_remark.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('21:evaluation_student_remark');

set @sql = concat("DELETE FROM exam_result_event_students where exam_result_event_students.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('22:exam_result_event_students');

set @sql = concat("DELETE FROM student_promotions where completionId in (
select completionId FROM completions where completions.admissionId IN (" , @admissionID , "))");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('23:student_promotions');

set @sql = concat("DELETE FROM completions where completions.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('24:completions');

set @sql = concat("DELETE FROM student_program_attendance_details where student_program_attendance_details.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('25:student_program_attendance_details');

set @sql = concat("DELETE FROM group_hw_assignment_documents where groupHomeworkAssignmentId in (
SELECT id FROM group_hw_assignment where group_hw_assignment.admissionId IN (" , @admissionID , "))");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('26:group_hw_assignment_documents');

set @sql = concat("DELETE FROM group_hw_assignment where group_hw_assignment.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('27:group_hw_assignment_documents');

set @sql = concat("DELETE FROM student_attendance_dashboard_student_wise where student_attendance_dashboard_student_wise.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('28:student_attendance_dashboard_student_wise');

set @sql = concat("DELETE FROM class_teacher_student_remarks where class_teacher_student_remarks.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('29:class_teacher_student_remarks');

set @sql = concat("DELETE FROM student_academic_topics where student_academic_topics.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('30:student_academic_topics');

set @sql = concat("DELETE FROM admission_student_documents where admission_student_documents.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;	
insert into templog_deletedStudentRecords values('31:admission_student_documents');

set @sql = concat("DELETE FROM student_course_attendance_details where student_course_attendance_details.admissionId IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('32:student_course_attendance_details');

set @sql = concat("DELETE FROM fee_adjustment_details where billFeeRuleStageId IN (
select id FROM bill_fee_plan_rule_stage where billId IN (
select id FROM bill_header where bill_header.userId IN (",studentIds, ") OR bill_header.studentId IN (",studentIds ,")))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('33:fee_adjustment_details');

set @sql = concat("DELETE FROM bill_dependant_details where billFeePlanRuleStageId IN (
SELECT id FROM bill_fee_plan_rule_stage where billId IN (
select id FROM bill_header where bill_header.userId IN (",studentIds, ") OR bill_header.studentId IN (",studentIds,")))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('34:bill_dependant_details');

set @sql = concat("DELETE FROM bill_fee_plan_rule_stage where billId IN (
select id FROM bill_header where bill_header.userId IN (",studentIds, ") OR bill_header.studentId IN (",studentIds,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('35:bill_fee_plan_rule_stage');

set @sql = concat("DELETE FROM bill_header where bill_header.userId IN (",studentIds,") OR bill_header.studentId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('36:bill_header');

set @sql = concat("DELETE FROM bill_fee_plan_rule_stage_tracking where billId IN (
SELECT id FROM bill_header_tracking where bill_header_tracking.userId IN (",studentIds,") OR bill_header_tracking.studentId IN (",studentIds,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('37:bill_fee_plan_rule_stage_tracking');

set @sql = concat("DELETE FROM bill_header_tracking where bill_header_tracking.userId IN (",studentIds,") OR bill_header_tracking.studentId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('38:bill_header_tracking');

set @sql = concat("DELETE FROM user_acad_loc_roles where user_acad_loc_roles.userAcadLocationId IN (",@userALID,")");
if (!ISNULL(@userALID) && LENGTH(TRIM(@userALID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('39:user_acad_loc_roles');

set @sql = concat("DELETE FROM user_academy_locations where user_academy_locations.userId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('40:user_academy_locations');

set @sql = concat("DELETE FROM student_documents where student_documents.studentId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('41:student_documents');

set @sql = concat("DELETE FROM fee_adjustment_master where receiptHeaderId IN (
select id FROM receipt_header where receipt_header.studentId IN (",studentIds,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('42:fee_adjustment_master');

set @sql = concat("DELETE FROM receipt_payment_instrument where receiptHeaderId in (
SELECT id FROM receipt_header where receipt_header.studentId IN (",studentIds,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('43:receipt_payment_instrument');

set @sql = concat("DELETE FROM receipt_header where receipt_header.studentId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('44:receipt_header');

set @sql = concat("DELETE FROM fee_plan_persons_covered where fee_plan_persons_covered.studentId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('45:fee_plan_persons_covered');

set @sql = concat("DELETE FROM installment_details where feeRelatedRequestDetailId IN (
SELECT id FROM fee_related_request_details where fee_related_request_details.studentId IN (",studentIds,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('46:installment_details');

set @sql = concat("DELETE FROM fee_related_request_details where fee_related_request_details.studentId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('47:fee_related_request_details');

set @sql = concat("DELETE FROM student_other_information_cd where studentOtherInfoId IN (
SELECT id FROM student_other_information where student_other_information.studentId IN (",studentIds,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('48:student_other_information_cd');

set @sql = concat("DELETE FROM student_other_information where student_other_information.studentId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('49:student_other_information');

set @sql = concat("DELETE FROM students where students.userId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('50:students');

set @sql = concat("DELETE FROM leave_report where leave_report.userId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('51:leave_report');

set @sql = concat("DELETE FROM usertries where usertries.userId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('52:usertries');

set @sql = concat("DELETE FROM users_system_usage_log where users_system_usage_log.userId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('53:users_system_usage_log');

set @sql = concat("DELETE FROM user_login_history where user_login_history.userId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('54:user_login_history');

set @sql = concat("DELETE FROM program_xfer_request_details where serviceRequestId IN (
select id FROM service_requests where service_requests.requester IN (",studentIds,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('55:program_xfer_request_details');

set @sql = concat("DELETE FROM followup_details where serviceRequestId IN (select id FROM service_requests where service_requests.requester IN (",studentIds,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('56:followup_details');

set @sql = concat("DELETE FROM service_requests where service_requests.requester IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('57:service_requests');

set @sql = concat("DELETE FROM academia_koha_sync where academia_koha_sync.userId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('58:academia_koha_sync');

set @sql = concat("DELETE FROM request_status where request_status.lastUpdatedBy IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('59:request_status');

set @sql = concat("DELETE FROM users where users.id IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('60:users');

set @sql = concat("DELETE p,u  FROM users u 
inner join parents p on u.id=p.userId 
inner join person_relationships pr on pr.relatedPersonId=p.personId
where pr.personId IN (",@personID,")");
if (!ISNULL(@personID) && LENGTH(TRIM(@personID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('61:Parents');

set @sql = concat("DELETE FROM person_relationships where person_relationships.personId IN (",@personID,")");
if (!ISNULL(@personID) && LENGTH(TRIM(@personID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('62:person_relationships');

set @sql = concat("DELETE FROM person_addresses where person_addresses.personId IN (",@personID,")");
if (!ISNULL(@personID) && LENGTH(TRIM(@personID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('63:person_addresses');


set @sql = concat("DELETE FROM person_relationships where person_relationships.personId IN (",@personID,") 
or relatedPersonId IN (",@personID,")");
if (!ISNULL(@personID) && LENGTH(TRIM(@personID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('64:person_relationships');

set @sql = concat("DELETE FROM persons where persons.id IN (",@personID,")");
if (!ISNULL(@personID) && LENGTH(TRIM(@personID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('65:persons');

set @sql = concat("DELETE FROM user_password_history where user_password_history.userId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('66:user_password_history');


-- Applicant Data Deletion 
set @sql = concat("select  group_concat(distinct ap.applicationId)  into @applicationIds
from admission a inner join application_program ap on a.applicationProgramId=ap.id
where a.studentId IN (",studentIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values(concat('67:@applicationIds-', @applicationIds));

set @sql = concat("select group_concat(distinct application.applicantPersonId) into @ApplicantPersonIds
from application where application.id IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values(concat('68:@ApplicantPersonIds-', @ApplicantPersonIds));

set @sql = concat("select group_concat(distinct application_program.id) into @ApplicantProgramIds
from application_program where application_program.applicationId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values(concat('69:@ApplicantProgramIds-', @ApplicantProgramIds));

set @sql = concat("select group_concat(distinct application_prog_stage.id)  into @ApplicantProgramStageIds
from application_prog_stage where application_prog_stage.applicationProgramId IN (", @ApplicantProgramIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values(concat('70:@ApplicantProgramStageIds-', @ApplicantProgramStageIds));


-- Delete Enquiries

/* set @sql = concat("select group_concat(distinct enquiryId) INTO @enquiryId from enq_student_details where
enq_student_details.id IN (select enquiryStudentDetailId from application where application.id IN (", @applicationIds,"))");
insert into templog_deletedStudentRecords values(concat('70: @enquiryId-',  @enquiryId)); */

-- Only single enquiry will be deleted for an applicant
set @sql = concat("select enquiryStudentDetailId INTO @enqStudDetailId from application where application.id IN (", @applicationIds,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;    
insert into templog_deletedStudentRecords values(concat('71: @enqStudDetailId-',  @enqStudDetailId));
   
select enq_student_details.enquiryId INTO @enquiryId from enq_student_details where
enq_student_details.id = @enqStudDetailId;
insert into templog_deletedStudentRecords values(concat('72: @enquiryId-',  @enquiryId));

if (!ISNULL(@enquiryId) && LENGTH(TRIM(@enquiryId))>0) THEN

    PREPARE stmt FROM @sql;
    EXECUTE stmt;


set @sql = concat("DELETE FROM admission_enq_details where enqStudentDetailsId IN (SELECT id FROM enq_student_details where enquiryId IN (",@enquiryId,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('73:admission_enq_details');

set @sql = concat("DELETE FROM enquiry_student_detail_cd where enquiry_student_detail_cd.enqStudentDetailId IN (SELECT id FROM enq_student_details where enquiryId IN (",@enquiryId,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('74:enquiry_student_detail_cd');

set @sql = concat("DELETE FROM enq_student_details where enquiryId IN (",@enquiryId,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('75:enq_student_details');

set @sql = concat("DELETE FROM enquiry_exam_detail_cf_data where examDetailId IN (SELECT id FROM enq_exams_details WHERE enquiryId IN (", @enquiryId,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('76:enquiry_exam_detail_cf_data');

set @sql = concat("DELETE FROM enquiry_exam_detail_cd where examDetailId IN (SELECT id FROM enq_exams_details WHERE enquiryId IN (", @enquiryId,"))");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('77:enquiry_exam_detail_cd');

set @sql = concat("DELETE FROM enq_exams_details WHERE enquiryId IN (", @enquiryId,")");

    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('78:enq_exams_details');

set @sql = concat("DELETE FROM enq_reopen_reason where enquiryId IN (",@enquiryId,")");
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('79:enq_reopen_reason');

set @sql = concat("DELETE FROM enq_closure_reason where enquiryId IN (",@enquiryId,")");
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('80:enq_closure_reason');

set @sql = concat("DELETE FROM enquiry_reassign where enquiryId IN (",@enquiryId,")");
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('81:enquiry_reassign');

set @sql = concat("DELETE FROM enq_followup where enquiryId IN (",@enquiryId,")");
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('82:enq_followup');

set @sql = concat("DELETE FROM enq_address where enquiryId IN (",@enquiryId,")");
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('83:enq_address');

set @sql = concat("DELETE FROM enquiry_cd where enquiryId IN (",@enquiryId,")");
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('84:enquiry_cd');

set @sql = concat("DELETE FROM enquiry where id IN (",@enquiryId,")");
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
insert into templog_deletedStudentRecords values('85:enquiry');
END IF;


-- Start Delete Applicant Selection stage Related Data
set @sql = concat("DELETE FROM application_prog_stage_status where  
application_prog_stage_status.applicationProgramStageId IN (", @ApplicantProgramStageIds,")");
if (!ISNULL(@ApplicantProgramStageIds) && LENGTH(TRIM(@ApplicantProgramStageIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('86:application_prog_stage_status');
 
set @sql = concat("DELETE FROM application_prog_stage_marks where  
application_prog_stage_marks.applicationProgramStageId IN (", @ApplicantProgramStageIds,")");
if (!ISNULL(@ApplicantProgramStageIds) && LENGTH(TRIM(@ApplicantProgramStageIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('87:application_prog_stage_marks');

-- Conditional admission documents
set @sql = concat("DELETE acdl,ed,d from application_condition_doc_log acdl inner join application_condition_log acl
on acdl.applicationConditionLogId=acl.id 
inner join documents d on d.id=acdl.documentId
inner join extended_documents ed on ed.documentId=d.id
where acl.applicationId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('88:application_condition_doc_log,documents,extended_documents ');

set @sql = concat("DELETE acl,ac FROM application_condition_log acl inner join application_condition ac
on acl.applicationConditionId=ac.id where acl.applicationId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('89:application_condition_log,application_condition');

-- End Delete Applicant Selection stage Related Data

-- Start Delete Applicant Fees related Data


set @sql = concat("DELETE afpd, afd FROM application_fee_plan_details afpd inner join application_fee_details afd
on afpd.applicationFeeDetailId=afd.id where afd.applicationId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('90:application_fee_plan_details,application_fee_details');

-- RECEIPT Adjustment Details  
set @sql = concat("DELETE  fad, fdm FROM fee_adjustment_details fad inner join fee_adjustment_master fdm
on fdm.id=fad.adjustmentMasterId
inner join receipt_header rh on rh.id=fdm.receiptHeaderId
where rh.applicantId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('91:fee_adjustment_details,fee_adjustment_master');

set @sql = concat("DELETE FROM receipt_payment_instrument where receiptHeaderId in (
select id FROM receipt_header where
receipt_header.applicantId IN (",@applicationIds,"))");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('92:receipt_payment_instrument');

--  RECEIPT Voucher

set @sql = concat("DELETE vd,rv,v from voucher_detail vd 
inner join voucher v on v.id=vd.voucherId
inner join receipt_voucher rv on v.id=rv.voucherId
inner join receipt_header rh on rh.id=rv.receiptHeaderId
where rh.applicantId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('93:voucher_detail,receipt_voucher,voucher');

-- RECEIPT 
set @sql = concat("DELETE FROM receipt_header where receipt_header.applicantId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('94:receipt_header');

-- PAYMENT Voucher 
set @sql = concat("DELETE vd,pv,v,ph from voucher_detail vd 
inner join voucher v on v.id=vd.voucherId
inner join payment_voucher pv on v.id=pv.voucherId
inner join payment_header ph on ph.id=pv.paymentHeaderId
where ph.applicantId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('95:voucher_detail,payment_voucher,voucher,payment_header');

-- BILL Voucher
set @sql = concat("DELETE vd,bv,v,bh from voucher_detail vd 
inner join voucher v on v.id=vd.voucherId
inner join bill_voucher bv on v.id=bv.voucherId
inner join bill_header bh on bh.id=bv.billId
where bh.applicantId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('96:voucher_detail,bill_voucher,voucher,bill_header');

-- BILL Adjustment Details  
set @sql = concat("DELETE  fad, fdm FROM fee_adjustment_details fad inner join fee_adjustment_master fdm
on fdm.id=fad.adjustmentMasterId
inner join bill_header bh on bh.id=fdm.billHeaderId
where bh.applicantId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('97:fee_adjustment_details,fee_adjustment_master');

-- Applicant Discount 
set @sql = concat("DELETE FROM applicant_student_discount_master 
where applicant_student_discount_master.applicantId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('98:applicant_student_discount_master');

 -- Bill Discount details
set @sql = concat("DELETE bdd FROM bill_fee_plan_rule_stage bfprs inner join bill_header bh on bfprs.billId=bh.id
inner join bill_discount_details bdd on bdd.billFeePlanRuleStageId=bfprs.id
where bh.applicantId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('99:bill_discount_details');

-- Bill And Fee plan rule stage details
set @sql = concat("DELETE bfprs FROM bill_fee_plan_rule_stage bfprs inner join bill_header bh on bfprs.billId=bh.id
where bh.applicantId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('100:bill_fee_plan_rule_stage');

-- BILL 
set @sql = concat("DELETE FROM bill_header where bill_header.applicantId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('101:bill_header');

set @sql = concat("DELETE from application_prog_stage where
application_prog_stage.id IN (", @ApplicantProgramStageIds,")");
if (!ISNULL(@ApplicantProgramStageIds) && LENGTH(TRIM(@ApplicantProgramStageIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('102:application_prog_stage');

-- END Delete Applicant Fees related Data


-- Start Delete Applicant other details Data

-- Applicant Documents
set @sql = concat("DELETE ard,ed,d from application_required_documents ard 
inner join documents d on d.id=ard.documentId
inner join extended_documents ed on ed.documentId=d.id
where ard.applicationId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('103:application_required_documents,extended_documents,documents');

set @sql = concat("DELETE FROM application_required_documents where
application_required_documents.applicationId IN (",@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('104:application_required_documents');
--

set @sql = concat("DELETE FROM applicant_address where 
applicant_address.applicantPersonId IN (", @ApplicantPersonIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('105:applicant_address');

set @sql = concat("DELETE FROM fee_payer_detail where  
fee_payer_detail.applicantPersonId IN (", @ApplicantPersonIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('106:fee_payer_detail');

set @sql = concat("DELETE  e1,e2 from external_user_association e1 inner join 
external_users e2 on e1.externalUserId=e2.id where
e1.applicationId IN (" ,@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('107:external_user_association,external_users');

set @sql = concat("DELETE FROM application_admission_detail where 
application_admission_detail.applicationProgramId IN (", @ApplicantProgramIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('108:application_admission_detail');

set @sql = concat("DELETE from application_timeline where 
application_timeline.applicationId IN (" ,@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('109:application_timeline');

set @sql = concat("DELETE from application_program where application_program.applicationId IN (" ,@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('110:application_program');

set @sql = concat("DELETE apr,ap  FROM applicant_person_relationships  apr inner join applicant_person ap on 
apr.relatedApplicantPersonId=ap.id
where apr.applicantPersonId IN (", @ApplicantPersonIds,")");
if (!ISNULL(@ApplicantPersonIds) && LENGTH(TRIM(@ApplicantPersonIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('111:applicant_person_relationships,applicant_person');

set @sql = concat("DELETE  a , af from application a inner join application_form af 
on a.applicationFormId =af.id where a.id IN (" ,@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('112:application,application_form');

set @sql = concat("DELETE FROM application where application.id IN (" ,@applicationIds,")");
if (!ISNULL(@applicationIds) && LENGTH(TRIM(@applicationIds))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('113:application');

set @sql = concat("DELETE FROM admission where admission.id IN (" , @admissionID , ")");
if (!ISNULL(@admissionID) && LENGTH(TRIM(@admissionID))>0) THEN
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
END IF;
insert into templog_deletedStudentRecords values('114:admission');

SET SQL_SAFE_UPDATES=1;
SET FOREIGN_KEY_CHECKS=1;
select now();
END$$

DELIMITER ;
