DELIMITER $$

DROP PROCEDURE IF EXISTS application_followup_create_proc $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE application_followup_create_proc()
BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='application_followup' )) THEN
    
	CREATE TABLE `application_followup` (
	  `id` bigint(20) NOT NULL AUTO_INCREMENT,
	  `userId` bigint(20) DEFAULT NULL,
	  `applicationId` bigint(20) DEFAULT NULL,
	  `assignTo` bigint(20) DEFAULT NULL,
	  `followUpNo` smallint(6) NOT NULL,
	  `followUpDate` date DEFAULT NULL,
	  `actualFollowUpDate` date DEFAULT NULL,
	  `whetherDeleted` bit(1) DEFAULT NULL,
	  `remark` text,
	  `lastUpdatedBy` bigint(20) NOT NULL,
	  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	  `isLatestFollowUp` bit(1) NOT NULL DEFAULT b'0',
	  `followupReason_id` bigint(20) DEFAULT NULL,
	  `followupActivityTypeId` bigint(20) NULL DEFAULT NULL,
	  `followupActivityStatusId` bigint(20) NULL DEFAULT NULL,
	  `followupTime` time NULL DEFAULT NULL, 
	  `enqPriorityId` BIGINT(20) NULL DEFAULT NULL,
	  `status` varchar(30) NULL DEFAULT NULL,
	  PRIMARY KEY (`id`),
	  KEY `Ref_application_5` (`applicationId`),
	  KEY `Ref_application_users35` (`userId`),
	  KEY `Ref_application_users335` (`lastUpdatedBy`),
	  KEY `Ref_application_users1867` (`assignTo`),
	  KEY `fk_application_followupReason_id` (`followupReason_id`),
	  KEY `fk_application_followupActivityTypeId` (`followupActivityTypeId`),
	  KEY `fk_application_followupActivityStatusId` (`followupActivityStatusId`),
	  KEY `fk_application_enqPriority` (`enqPriorityId`),
	  CONSTRAINT `fk_application_followupActivityStatusId` FOREIGN KEY (`followupActivityStatusId`) REFERENCES `follow_up_activity_status` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
	  CONSTRAINT `fk_application_followupActivityTypeId` FOREIGN KEY (`followupActivityTypeId`) REFERENCES `follow_up_activity_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
	  CONSTRAINT `fk_application_followupReason_id` FOREIGN KEY (`followupReason_id`) REFERENCES `reason_for_follow_up` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
	  CONSTRAINT `Ref_application_5` FOREIGN KEY (`applicationId`) REFERENCES `application` (`id`),
	  CONSTRAINT `Ref_application_users1867` FOREIGN KEY (`assignTo`) REFERENCES `users` (`id`),
	  CONSTRAINT `Ref_application_users335` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
	  CONSTRAINT `Ref_application_users35` FOREIGN KEY (`userId`) REFERENCES `users` (`id`),
	  CONSTRAINT `fk_application_enqPriority` FOREIGN KEY (`enqPriorityId`) REFERENCES `enq_priority` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
	);
	
  END IF ;

END $$

-- Execute the stored procedure
CALL application_followup_create_proc $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS application_followup_create_proc $$
 
DELIMITER ;
