DELIMITER $$

DROP PROCEDURE IF EXISTS application_owner_event $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE application_owner_event()

BEGIN
	
	-- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE `objectName` = 'MESSAGING_TRANSLATIONS' AND `keyName` = 'APPLICATION_FORM_CREATION_OWNER' )) THEN
    
	-- Insert Query
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('MESSAGING_TRANSLATIONS','APPLICATION_FORM_CREATION_OWNER','Application Form Creation - Owner','Application Form Creation - Owner',now(),1); 

  END IF;
  
  -- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key` = 'APPLICATION_FORM_CREATION_OWNER' )) THEN
    
	-- Insert Query
	INSERT INTO `picklist_translation` (`key`, `en`) 
	VALUES ('APPLICATION_FORM_CREATION_OWNER', 'Application Form Creation - Owner'); 

  END IF;
  
  -- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key` = 'APPLICATION_OWNER_RECIPIENT' )) THEN
    
	-- Insert Query
	INSERT INTO `picklist_translation` (`key`, `en`) 
	VALUES ('APPLICATION_OWNER_RECIPIENT', 'Application Owner'); 

  END IF;

END $$

-- Execute the stored procedure
CALL application_owner_event() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS application_owner_event $$
 
DELIMITER ;