DELIMITER $$

DROP PROCEDURE IF EXISTS V202001141253__EntryOfOldGenderToNewGenderId $$

CREATE PROCEDURE V202001141253__EntryOfOldGenderToNewGenderId()

BEGIN

  IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='enq_student_details' 
  AND column_name='genderId')) THEN

    SET SQL_SAFE_UPDATES = 0;

	Update enq_student_details as T1 INNER JOIN gender as T2 ON (T1.gender = T2.itemCode)
	SET T1.genderId = T2.id 
	WHERE T1.gender IS NOT NULL;
    
	SET SQL_SAFE_UPDATES = 1;
	
  END IF;

END $$

CALL V202001141253__EntryOfOldGenderToNewGenderId $$

DROP PROCEDURE IF EXISTS V202001141253__EntryOfOldGenderToNewGenderId $$

DELIMITER ;