DELIMITER $$

DROP PROCEDURE IF EXISTS V202001152005__CampaignNewCustomData $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001152005__CampaignNewCustomData()

BEGIN
  
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='campaign_new_cd' )) THEN
    
	CREATE TABLE `campaign_new_cd` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `campaignNewId` bigint(20) DEFAULT NULL,
  `cf1` varchar(255) DEFAULT NULL,
  `cf2` varchar(255) DEFAULT NULL,
  `cf3` varchar(255) DEFAULT NULL,
  `cf4` varchar(255) DEFAULT NULL,
  `cf5` varchar(255) DEFAULT NULL,
  `cf6` varchar(255) DEFAULT NULL,
  `cf7` varchar(255) DEFAULT NULL,
  `cf8` varchar(255) DEFAULT NULL,
  `cf9` varchar(255) DEFAULT NULL,
  `cf10` varchar(255) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` date DEFAULT NULL,
  `cf15` date DEFAULT NULL,
  `cf16` tinyint(1) DEFAULT NULL,
  `cf17` tinyint(1) DEFAULT NULL,
  `cf18` varchar(255) DEFAULT NULL,
  `cf19` varchar(255) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  CONSTRAINT `ref_campaign_new_cd_id` FOREIGN KEY (`campaignNewId`) REFERENCES `campaign_new` (`id`),
  CONSTRAINT `ref_campaign_new_cd_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  END IF;
  
	 IF NOT EXISTS ((SELECT * FROM `custom_table_configs` WHERE tableName = 'campaign_new' )) THEN
	  INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) 
      VALUES ('Buzz Campaign','campaign_new','campaign_new_cd');

  END IF;

END $$

-- Execute the stored procedure
CALL V202001152005__CampaignNewCustomData() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001152005__CampaignNewCustomData $$
 
DELIMITER ;
