DELIMITER $$

DROP PROCEDURE IF EXISTS add_report_template $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE add_report_template()

BEGIN
 
-- Insert new record in report_template table, if it doesn't already exist
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'STUDENT_ATTENDANCE_COMPLETE_DAY_REPORT_REGISTER_BLANK' )) THEN
   
-- Insert Query
    INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('10', 'STUDENT_ATTENDANCE_COMPLETE_DAY_REPORT_REGISTER_BLANK', 'Student Complete Day Register Report Blank', 'STUDENT_ATTENDANCE_COMPLETE_DAY_REPORT_REGISTER.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'AttendanceRegister_ForCompleteDay_Blank.jasper', 'AcademiaLogo.png');

  END IF;

END $$

-- Execute the stored procedure
CALL add_report_template() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS add_report_template $$
 
DELIMITER ;