DELIMITER $$

DROP PROCEDURE IF EXISTS V202001232005__AlterCustomTableConfig $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001232005__AlterCustomTableConfig()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='custom_table_configs' 
  AND column_name='viewCode')) THEN

    ALTER TABLE `custom_table_configs` 
    ADD COLUMN `viewCode` VARCHAR(255) NULL DEFAULT NULL AFTER `customTableName`;

  END IF;

END $$

-- Execute the stored procedure
CALL V202001232005__AlterCustomTableConfig() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001232005__AlterCustomTableConfig $$
 
DELIMITER ;


