DELIMITER $$
DROP PROCEDURE IF EXISTS V202001271620__Alter_report $$
CREATE PROCEDURE V202001271620__Alter_report()
BEGIN
CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `faculty_view` AS
    select 
        `usr`.`code` AS `RegistrationId`,
        `usr`.`printName` AS `Name`,
        `per`.`emailId` AS `Email`,
        `per`.`mobileNumber` AS `Phone`,
        `dpt`.`deptName` AS `DepartmentName`,
        `dpt`.`shortCode` AS `DepartmentCode`,
        `gender`.`itemValue` AS `Gender`
    from
        ((((`staffs` `stf`
        join `users` `usr` ON ((`usr`.`id` = `stf`.`userId`)))
        join `persons` `per` ON ((`per`.`id` = `stf`.`personId`)))
        join `department` `dpt` ON ((`dpt`.`id` = `stf`.`departmentId`)))
        join `gender` `gender` ON ((`gender`.`id` = `per`.`genderId`)))
    where
        ((`stf`.`whetherFaculty` = 1)
            and (`usr`.`status` = 1)
            and (`usr`.`whetherDeleted` = 0));
END $$
CALL V202001271620__Alter_report() $$
DROP PROCEDURE IF EXISTS V202001271620__Alter_report $$
DELIMITER ;