DELIMITER $$

DROP PROCEDURE IF EXISTS UI_SALES_ADMISSION_REPORT_GRID $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE UI_SALES_ADMISSION_REPORT_GRID()

BEGIN
  
   -- Insert new record in email table, if it doesn't already exist
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'ADMISSION' AND keyName='ACADEMY_ENQUIRIES' )) THEN
    
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `lastUpdate`, `lastUpdatedBy`)
	VALUES ('ADMISSION', 'ACADEMY_ENQUIRIES', 'Enquiries', 'Enquiries', now(), '1');
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'ADMISSION' AND keyName='ACADEMY_APPLICATIONS' )) THEN
    
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `lastUpdate`, `lastUpdatedBy`)
	VALUES ('ADMISSION', 'ACADEMY_APPLICATIONS', 'Applications', 'Applications', now(), '1');
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'ADMISSION' AND keyName='ACADEMY_ACCEPTED_APPLICATIONS' )) THEN
    
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `lastUpdate`, `lastUpdatedBy`)
	VALUES ('ADMISSION', 'ACADEMY_ACCEPTED_APPLICATIONS', 'Accepted Applications', 'Accepted Applications', now(), '1');
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'ADMISSION' AND keyName='ACADEMY_ADMISSION' )) THEN
    
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `lastUpdate`, `lastUpdatedBy`)
	VALUES ('ADMISSION', 'ACADEMY_ADMISSION', 'Admissions', 'Admissions', now(), '1');
  END IF;

END $$

-- Execute the stored procedure
CALL UI_SALES_ADMISSION_REPORT_GRID() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS UI_SALES_ADMISSION_REPORT_GRID $$
 
DELIMITER ;