DELIMITER $$
DROP PROCEDURE IF EXISTS V20200312141632__Create_hostelServiceRequestSettings $$
CREATE PROCEDURE V20200312141632__Create_hostelServiceRequestSettings()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='hostel_servicerequest_setting') THEN 
CREATE TABLE `hostel_servicerequest_setting` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `hostelId` BIGINT(20) NULL DEFAULT NULL,
  `defaultAssigneeUserId` BIGINT(20) NULL,
  `defaultApproverUserId` BIGINT(20) NULL,
  `serviceRequestSettingId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  PRIMARY KEY (`id`));

ALTER TABLE `hostel_servicerequest_setting` 
ADD INDEX `fk_hsrs_hosteId_idx` (`hostelId` ASC),
ADD INDEX `fk_hsrs_assigneeid_idx` (`defaultAssigneeUserId` ASC),
ADD INDEX `fk_hsrs_approverid_idx` (`defaultApproverUserId` ASC),
ADD INDEX `fk_hsrs_servicerequestsettiing_idx` (`serviceRequestSettingId` ASC),
ADD INDEX `fk_hsrs_lastupdated_idx` (`lastUpdatedBy` ASC);
ALTER TABLE `hostel_servicerequest_setting` 
ADD CONSTRAINT `fk_hsrs_hosteId`
  FOREIGN KEY (`hostelId`)
  REFERENCES `hostel` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_hsrs_assigneeid`
  FOREIGN KEY (`defaultAssigneeUserId`)
  REFERENCES `users` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_hsrs_approverid`
  FOREIGN KEY (`defaultApproverUserId`)
  REFERENCES `users` (`id`)
  ON DELETE  RESTRICT
  ON UPDATE  RESTRICT,
ADD CONSTRAINT `fk_hsrs_servicerequestsettiing`
  FOREIGN KEY (`serviceRequestSettingId`)
  REFERENCES `service_request_settings` (`id`)
  ON DELETE RESTRICT
  ON UPDATE  RESTRICT,
ADD CONSTRAINT `fk_hsrs_lastupdated`
  FOREIGN KEY (`lastUpdatedBy`)
  REFERENCES `users` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
END IF; 

END $$
CALL V20200312141632__Create_hostelServiceRequestSettings () $$ 
DROP PROCEDURE IF EXISTS V20200312141632__Create_hostelServiceRequestSettings $$ 
DELIMITER ;