DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402153410__Create_analytics_receipt_view $$
CREATE PROCEDURE V20200402153410__Create_analytics_receipt_view()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'Analytics_Receipt_View')) THEN 
DROP view `Analytics_Receipt_View`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'analytics_receipt_view')) THEN 
CREATE OR REPLACE VIEW `analytics_receipt_view` AS
 select 
        `al`.`academyName` AS `Academy`,
        `al`.`locationName` AS `Location`,
        `al`.`displayName` AS `Academy Location`,
        `al`.`id` AS `Academy Location Id`,
        `pg`.`groupName` AS `Program Group`,
        `pc`.`categoryName` AS `Program Category`,
        `program`.`programSequence` AS `Program Sequence`,
        `program`.`programName` AS `Program`,
		`program`.`programNameToBePrint` AS `programNameToBePrint`,
        `iy`.`itemValue` AS `Intake Year`,
        `batch`.`batchName` AS `Batch`,
        `st`.`seatName` AS `Seat type`,
        `but`.`billedUserType` AS `Receipt For`,
        `u`.`code` AS `Student Id`,
        `u`.`printName` AS `Student Name`,
        `rh`.`receiptNo` AS `Receipt No`,
        `rh`.`transactionDate` AS `Receipt Date`,
        `c`.`currencyName` AS `Currency`,
        `but`.`raiseBillType` AS `Receipt Type`,
        `b`.`bankName` AS `Deposit Bank`,
        `rh`.`voucherMode` AS `Voucher Mode`,
        `fpm`.`paymentModeName` AS `Instrument Type`,
        `rpi`.`instrumentNo` AS `Instrument No.`,
        `bdom`.`bankName` AS `Drawn On Bank`,
        `rh`.`amount` AS `Receipt Amount`,
        `rh`.`status` AS `Receipt Status`,
        `fam`.`adjustedAmount` AS `Settled Amount`,
        `fam`.`balanceAmount` AS `Balance Amount`
    from
        (((((((((((((((((((`receipt_header` `rh`
        left join `receipt_payment_instrument` `rpi` ON ((`rpi`.`receiptHeaderId` = `rh`.`id`)))
        left join `fee_adjustment_master` `fam` ON ((`fam`.`receiptHeaderId` = `rh`.`id`)))
        left join `fee_payment_modes` `fpm` ON ((`fpm`.`id` = `rpi`.`paymentMode`)))
        left join `bank` `b` ON ((`rh`.`depositedBank` = `b`.`id`)))
        left join `bank_drawn_on_master` `bdom` ON ((`bdom`.`id` = `rpi`.`instrumentBank`)))
        left join `currency` `c` ON ((`rh`.`currencyId` = `c`.`id`)))
        left join `users` `u` ON ((`rh`.`studentId` = `u`.`id`)))
        left join `admission` ON ((`admission`.`studentId` = `u`.`id`)))
        left join `program_batch_students` `pbs` ON ((`admission`.`id` = `pbs`.`admissionId`)))
        left join `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `pbs`.`progBatchSeatConfigId`)))
        left join `seat_types` `st` ON ((`st`.`id` = `pbsc`.`seatTypeId`)))
        left join `batches` `batch` ON ((`batch`.`id` = `pbs`.`programBatchId`)))
        left join `intake_year` `iy` ON ((`iy`.`id` = `batch`.`intakeYearId`)))
        left join `programs` `program` ON ((`program`.`id` = `batch`.`programId`)))
        left join `program_group` `pg` ON ((`pg`.`id` = `program`.`programGroupId`)))
        left join `program_category` `pc` ON ((`program`.`programCategoryId` = `pc`.`id`)))
        left join `user_academy_locations` `ual` ON ((`u`.`id` = `ual`.`userId`)))
        left join `academy_location` `al` ON ((`al`.`id` = `ual`.`academyLocationId`)))
        left join `billed_user_type` `but` ON ((`rh`.`receiptFor` = `but`.`id`)))
    where
        ((`al`.`academyName` is not null)
            and (`rh`.`status` <> 'CANCELLED'))
    group by `rh`.`id` , `rpi`.`instrumentNo`;
END IF; 

END $$
CALL V20200402153410__Create_analytics_receipt_view () $$ 
DROP PROCEDURE IF EXISTS V20200402153410__Create_analytics_receipt_view $$ 
DELIMITER ;