DELIMITER $$
DROP PROCEDURE IF EXISTS V20200408175323__Create_CourseCoveragePlanTopic $$
CREATE PROCEDURE V20200408175323__Create_CourseCoveragePlanTopic()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_coverage_plan_topic' )) THEN 
CREATE TABLE `course_coverage_plan_topic` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `courseCoveragePlanId` BIGINT(20) NOT NULL,
  `courseTopicId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` DATETIME NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sessionTopicUnique` (`courseCoveragePlanId`,`courseTopicId`),
  INDEX `fk_course_coverage_plan_topic_1_idx` (`courseCoveragePlanId` ASC),
  INDEX `fk_course_coverage_plan_topic_2_idx` (`courseTopicId` ASC),
  INDEX `fk_course_coverage_plan_topic_3_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_course_coverage_plan_topic_1`
    FOREIGN KEY (`courseCoveragePlanId`)
    REFERENCES `course_coverage_plan` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_coverage_plan_topic_2`
    FOREIGN KEY (`courseTopicId`)
    REFERENCES `course_topics` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_coverage_plan_topic_3`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF; 

END $$
CALL V20200408175323__Create_CourseCoveragePlanTopic () $$ 
DROP PROCEDURE IF EXISTS V20200408175323__Create_CourseCoveragePlanTopic $$ 
DELIMITER ;