DELIMITER $$

DROP PROCEDURE IF EXISTS V202003201844__UITranslation_ForSRLeaveIntimation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202003201844__UITranslation_ForSRLeaveIntimation()

BEGIN
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='SR_LEAVE_INTIMATION')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','SR_LEAVE_INTIMATION','Service Request Leave Intimation','Service Request Leave Intimation',now(),1);

  END IF; 
  
   IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='SR_LEAVE_ASSIGNEE_INTIMATION_DL')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','SR_LEAVE_ASSIGNEE_INTIMATION_DL','Leave Assignee Intimation DL','Leave Assignee Intimation DL',now(),1);

  END IF; 
  
   IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='SR_LEAVE_STUDENT_INTIMATION_DL')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','SR_LEAVE_STUDENT_INTIMATION_DL','Leave Student Intimation DL','Leave Student Intimation DL',now(),1);

  END IF; 
  
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='SR_LEAVE_ASSIGNEE_INTIMATION_RCPNT')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','SR_LEAVE_ASSIGNEE_INTIMATION_RCPNT','Leave Assignee Intimation Recipient','Leave Assignee Intimation Recipient',now(),1);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='SR_LEAVE_STUDENT_INTIMATION_RCPNT')) THEN
   
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','SR_LEAVE_STUDENT_INTIMATION_RCPNT','Leave Student Intimation Recipient','Leave Student Intimation Recipient',now(),1);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='SR_LEAVE_INTIMATION')) THEN

  INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('SR_LEAVE_INTIMATION', 'Service Request Leave Intimation');

  END IF;
  
   IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='SR_LEAVE_ASSIGNEE_INTIMATION_DL')) THEN

  INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('SR_LEAVE_ASSIGNEE_INTIMATION_DL', 'Leave Assignee Intimation DL');

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='SR_LEAVE_STUDENT_INTIMATION_DL')) THEN

  INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('SR_LEAVE_STUDENT_INTIMATION_DL', 'Leave Student Intimation DL');

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='SR_LEAVE_ASSIGNEE_INTIMATION_RCPNT')) THEN

  INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('SR_LEAVE_ASSIGNEE_INTIMATION_RCPNT', 'Leave Assignee Intimation Recipient');

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='SR_LEAVE_STUDENT_INTIMATION_RCPNT')) THEN

  INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('SR_LEAVE_STUDENT_INTIMATION_RCPNT', 'Leave Student Intimation Recipient');

  END IF;

END $$

-- Execute the stored procedure
CALL V202003201844__UITranslation_ForSRLeaveIntimation() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202003201844__UITranslation_ForSRLeaveIntimation $$
 
DELIMITER ;