DELIMITER $$
DROP PROCEDURE IF EXISTS V20200505152406__Insert_NewReportType $$
CREATE PROCEDURE V20200505152406__Insert_NewReportType()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_type` WHERE typeName = 'Planning Reports' )) THEN
INSERT INTO `report_type` (`typeName`) VALUES ('Planning Reports'); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'D1_TEACHING_PLAN' )) THEN 

set @reportTypeId = (select id from report_type WHERE typeName = 'Planning Reports');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeId, 'D1_TEACHING_PLAN', 'D1 - Teaching Plan', 'D1_TEACHING_PLAN.png', 'D1_TEACHING_PLAN_CommonReport_Landscape.jasper', 'All', '1', 'FooterBlank_Landscape.jasper', 'FooterBlank_Landscape.jasper', '1', '1', 'D1_TEACHING_PLAN.jasper', 'AcademiaLogo.png'); 

set @d1TeachingPlan = (select max(id) from report_template where templateCode ='D1_TEACHING_PLAN');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@d1TeachingPlan, 'TRANS_D1', 'D1 labels', '1', NOW()),
(@d1TeachingPlan, 'TRANS_BOARD_NAME', 'Maharashtra State Board of Technical Education', '1', NOW()),
(@d1TeachingPlan, 'TRANS_TEACHING_PLAN', 'TEACHING PLAN (TP)', '1', NOW()),
(@d1TeachingPlan, 'TRANS_ACADEMIC_YEAR', 'Academic Year:', '1', NOW()),
(@d1TeachingPlan, 'TRANS_PROGRAM', 'Program:', '1', NOW()),
(@d1TeachingPlan, 'TRANS_SEMESTER', 'Semester:', '1', NOW()),
(@d1TeachingPlan, 'TRANS_FACULTY_NAME', 'Name of Faculty:', '1', NOW()),
(@d1TeachingPlan, 'TRANS_COURSE_CODE', 'Course Code:', '1', NOW()),
(@d1TeachingPlan, 'TRANS_COURSE', 'Course:', '1', NOW()),
(@d1TeachingPlan, 'TRANS_SECTION', 'Section:', '1', NOW()),
(@d1TeachingPlan, 'TRANS_CHAPTER_NUMBER', 'Chapter No. (Allocated Hrs.)', '1', NOW()), 
(@d1TeachingPlan, 'TRANS_CO', 'CO', '1', NOW()),
(@d1TeachingPlan, 'TRANS_UO', 'UO', '1', NOW()),
(@d1TeachingPlan, 'TRANS_TITLE', 'Title/Details', '1', NOW()),
(@d1TeachingPlan, 'TRANS_PLAN_FROM_TO', 'Plan (From-To & No. of Lectures)', '1', NOW()),
(@d1TeachingPlan, 'TRANS_REMARKS', 'Remarks', '1', NOW()),
(@d1TeachingPlan, 'TRANS_ACTUAL_EXECUTION', 'Actual Execution (From-To & No. of Lectures)', '1', NOW()),
(@d1TeachingPlan, 'TRANS_TEACHING_METHOD', 'Teaching Method/Media', '1', NOW()),
(@d1TeachingPlan, 'TRANS_FACULTY_SIGNATURE', '(Name & Signature of Faculty)', '1', NOW()),
(@d1TeachingPlan, 'TRANS_HOD_SIGNATURE', '(Name & Signature of HOD)', '1', NOW());

END IF; 

END $$
CALL V20200505152406__Insert_NewReportType() $$
DROP PROCEDURE IF EXISTS V20200505152406__Insert_NewReportType $$
DELIMITER ;
