DELIMITER $$
DROP PROCEDURE IF EXISTS V20200513153647__Create_student_level_remark_status $$
CREATE PROCEDURE V20200513153647__Create_student_level_remark_status()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_level_remark_status')) THEN 
CREATE TABLE `student_level_remark_status` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `periodId` BIGINT(20) NOT NULL,
  `planId` BIGINT(20) NULL,
  `typeId` BIGINT(20) NULL,
  `subtypeId` BIGINT(20) NULL,
  `methodId` BIGINT(20) NULL,
  `status` VARCHAR(45) NOT NULL DEFAULT 'OPEN',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
UNIQUE KEY `student_level_remark_unique_period_plan` (`periodId`,`planId`),
UNIQUE KEY `student_level_remark_unique_period_type` (`periodId`,`typeId`),
UNIQUE KEY `student_level_remark_unique_period_subtype` (`periodId`,`subtypeId`),
UNIQUE KEY `student_level_remark_unique_period_method` (`periodId`,`methodId`),

  KEY `fk_student_level_remark_status_1_idx` (`periodId`),
  KEY `fk_student_level_remark_status_2_idx` (`planId`),
  KEY `fk_student_level_remark_status_3_idx` (`typeId`),
  KEY `fk_student_level_remark_status_4_idx` (`subtypeId`),
  KEY `fk_student_level_remark_status_5_idx` (`methodId`),
  KEY `fk_student_level_remark_status_6_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_student_level_remark_status_1` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_student_level_remark_status_2` FOREIGN KEY (`planId`) REFERENCES `evaluation_plan` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_student_level_remark_status_3` FOREIGN KEY (`typeId`) REFERENCES `evaluation_plan_level_one` (`id`)ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_student_level_remark_status_4`FOREIGN KEY (`subtypeId`) REFERENCES `evaluation_plan_level_two` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_student_level_remark_status_5`FOREIGN KEY (`methodId`) REFERENCES `evaluation_sequence` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
CONSTRAINT `fk_student_level_remark_status_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
)ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20200513153647__Create_student_level_remark_status () $$ 
DROP PROCEDURE IF EXISTS V20200513153647__Create_student_level_remark_status $$ 
DELIMITER ;