DELIMITER $$
DROP PROCEDURE IF EXISTS V20200521202718__Create_SchedulePaymentMode $$
CREATE PROCEDURE V20200521202718__Create_SchedulePaymentMode()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='schedule_payment_mode')) THEN 
CREATE TABLE `schedule_payment_mode` (
  `id` BIGINT NOT NULL,
  `paymentPlanScheduleId` BIGINT NOT NULL,
  `feePaymentModeId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_schedule_payment_mode_to_payment_schedule_idx` (`paymentPlanScheduleId` ASC),
  INDEX `fk_schedule_payment_mode_to_fee_payment_mode_idx` (`feePaymentModeId` ASC),
  CONSTRAINT `fk_schedule_payment_mode_to_payment_schedule`
    FOREIGN KEY (`paymentPlanScheduleId`)
    REFERENCES `payment_plan_schedule` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_schedule_payment_mode_to_fee_payment_mode`
    FOREIGN KEY (`feePaymentModeId`)
    REFERENCES `fee_payment_modes` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20200521202718__Create_SchedulePaymentMode () $$ 
DROP PROCEDURE IF EXISTS V20200521202718__Create_SchedulePaymentMode $$ 
DELIMITER ;