DELIMITER $$

DROP PROCEDURE IF EXISTS V20200618121500__Create_Student_Payment_Plan_Document $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200618121500__Create_Student_Payment_Plan_Document()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_plan_required_document_status')) THEN
    
CREATE TABLE `payment_plan_required_document_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paymentPlanDocumentId` bigint(20) NOT NULL,
  `studentId` bigint(20) NOT NULL,
  `status` VARCHAR(50) NOT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
 
  PRIMARY KEY (`id`),
  
  INDEX `fk_payment_plan_document_student_payment_plan_document_idx` (`paymentPlanDocumentId` ASC),
  INDEX `fk_payment_plan_document_student_students_idx` (`studentId` ASC),
  INDEX `fk_payment_plan_document_student_documents_idx` (`documentId` ASC),
  INDEX `fk_payment_plan_document_student_to_user_idx` (`lastUpdatedBy` ASC),
  
  CONSTRAINT `fk_payment_plan_document_student_payment_plan_document_idx`  FOREIGN KEY (`paymentPlanDocumentId`)  REFERENCES `payment_plan_document` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_document_student_students_id_idx`  FOREIGN KEY (`studentId`)  REFERENCES `students` (`userId`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_document_student_documents_idx`  FOREIGN KEY (`documentId`)  REFERENCES `documents` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_document_student_to_user` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)  ON DELETE RESTRICT ON UPDATE RESTRICT);

  END IF;

END $$

-- Execute the stored procedure
CALL V20200618121500__Create_Student_Payment_Plan_Document() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200618121500__Create_Student_Payment_Plan_Document $$
 
DELIMITER ;