DELIMITER $$

DROP PROCEDURE IF EXISTS V20200711152910__InsertApplicationDuplicateGridTitle $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200711152910__InsertApplicationDuplicateGridTitle()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='DUPLICATE_APPLICATION_EMAIL_DETAILS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','DUPLICATE_APPLICATION_EMAIL_DETAILS','Duplicate Application Email Details','Duplicate Application Email Details','Dupliseer die e-posinligting van die aansoek','Chi tiết email ứng dụng trùng lặp',now(),1);
 END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='DUPLICATE_APPLICATION_NATIONAL_ID_DETAILS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','DUPLICATE_APPLICATION_NATIONAL_ID_DETAILS','Duplicate Application National ID Details','Duplicate Application National ID Details','Duplikaat-aansoekvorm se nasionale ID-besonderhede','Ứng dụng trùng lặp Chi tiết ID quốc gia',now(),1);

  END IF;
  
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='DUPLICATE_APPLICATION_DETAILS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','DUPLICATE_APPLICATION_DETAILS','Duplicate Application Details','Duplicate Application Details','Duplicate Application Details','Chi tiết ứng dụng trùng lặp',now(),1);

  END IF;  

END $$

-- Execute the stored procedure
CALL V20200711152910__InsertApplicationDuplicateGridTitle() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200711152910__InsertApplicationDuplicateGridTitle $$
 
DELIMITER ;