DELIMITER $$
DROP PROCEDURE IF EXISTS V20200713184822__Create_CurrentGradeTableForCSM $$
CREATE PROCEDURE V20200713184822__Create_CurrentGradeTableForCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='current_grade')) THEN
CREATE TABLE IF NOT EXISTS `current_grade` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'CURRENT_GRADE')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'current_grade','CURRENT_GRADE','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;


IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'current_grade');
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`) VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`) VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

END IF; 

END $$
CALL V20200713184822__Create_CurrentGradeTableForCSM() $$
DROP PROCEDURE IF EXISTS V20200713184822__Create_CurrentGradeTableForCSM $$
DELIMITER ;
