DELIMITER $$
DROP PROCEDURE IF EXISTS V20200714155932__Insert_ReportTemplateSNJBStudentBill $$
CREATE PROCEDURE V20200714155932__Insert_ReportTemplateSNJBStudentBill()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `reportTypeId`='3' and `templateCode` = 'MANAGE_BILLS_CODE' and `templateName`='SNJB Student Bill')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('3', 'MANAGE_BILLS_CODE', 'SNJB Student Bill', 'SNJBStudentBill.png', 'CommonReport_LandScape.jasper', 'All', '0', 'HeaderBlank_LandScape.jasper', 'FooterBlank.jasper', '0', '0', 'ManageBillSNJBStudent.jasper', 'AcademiaLogo.png');
set @reportTemplateId = (select id from report_template WHERE reportTypeId = '3' AND templateCode = 'MANAGE_BILLS_CODE' AND templateName='SNJB Student Bill');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTemplateId , 'TRANS_CHALLAN_NO', 'Challan No.', '1', NOW()),
(@reportTemplateId , 'TRANS_BRANCH_NAME', 'Branch Name', '1', NOW()),
(@reportTemplateId , 'TRANS_DATE', 'Date', '1', NOW()),
(@reportTemplateId , 'TRANS_ADMISSION_NO', 'Admission No.', '1', NOW()),
(@reportTemplateId , 'TRANS_STUDENT_NAME', 'Student Name', '1', NOW()),
(@reportTemplateId , 'TRANS_MOBILE_NO_CATEGORY', 'Mob. No./Category', '1', NOW()),
(@reportTemplateId , 'TRANS_DEGREE', 'Degree', '1', NOW()),
(@reportTemplateId , 'TRANS_ACADEMIC_YEAR', 'Academic Year', '1', NOW()),
(@reportTemplateId , 'TRANS_FEES_TYPE', 'Fees Type', '1', NOW()),
(@reportTemplateId , 'TRANS_AMOUNT', 'Amount', '1', NOW()),
(@reportTemplateId , 'TRANS_CHEQUE_DD_NO', 'Cheque/DDNo.', '1', NOW()),
(@reportTemplateId , 'TRANS_CHEQUE_DATE', 'Cheque Date', '1', NOW()),
(@reportTemplateId , 'TRANS_BANK', 'Bank', '1', NOW()),
(@reportTemplateId , 'TRANS_ACCOUNTANT_SIGNATURE', 'Accountant Signature', '1', NOW()),
(@reportTemplateId , 'TRANS_CANDIDATE_SIGNATURE', 'Candidate\'s Signature', '1', NOW()),
(@reportTemplateId , 'TRANS_PAID_INTO_CREDIT_OF_CURRENT_BANK_ACCOUNT', 'Paid into credit of current Bank Account No. the sum of', '1', NOW()),
(@reportTemplateId , 'TRANS_BANK_SEAL', 'Bank Seal', '1', NOW()),
(@reportTemplateId , 'TRANS_PLACE', 'Place:', '1', NOW()),
(@reportTemplateId , 'TRANS_RECEIVING_CASHIER', 'Receiving Cashier', '1', NOW());
END IF; 

END $$
CALL V20200714155932__Insert_ReportTemplateSNJBStudentBill() $$
DROP PROCEDURE IF EXISTS V20200714155932__Insert_ReportTemplateSNJBStudentBill $$
DELIMITER ;