DELIMITER $$

DROP PROCEDURE IF EXISTS V20200729101035__InsertUITRNSForPersonPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200729101035__InsertUITRNSForPersonPortal()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='BIRTH_PLACE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','BIRTH_PLACE','Place of Birth','Place of Birth','Plek van geboorte', 'Nơi sinh',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='BIRTH_PLACE_OTHER_LANGUAGE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','BIRTH_PLACE_OTHER_LANGUAGE','Place of Birth-Other Language','Place of Birth-Other Language','Geboorteplek - ander taal', 'Nơi sinh-Ngôn ngữ khác',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='EXAM_BOARD')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','EXAM_BOARD','Exam Board','Exam Board','Eksamenraad', 'Bảng kiểm tra',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='INSTRUCTION_MEDIUM')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','INSTRUCTION_MEDIUM','Medium of Instructions','Medium of Instructions','Medium van instruksies', 'Công cụ giảng dạy',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='BOOKING_ID')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','BOOKING_ID','Booking ID','Booking ID','Besprekings-ID', 'ID đặt chỗ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='APPLICANT_ID_NAME')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','APPLICANT_ID_NAME','Applicant ID/Name','Applicant ID/Name','Aansoeker ID / Naam', 'ID / Tên người nộp đơn',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='APPOINTMENT_DATE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','APPOINTMENT_DATE','Appointment Date','Appointment Date','Aanstellingsdatum', 'Ngày hẹn',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='EXPECTED_OUT_TIME')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','EXPECTED_OUT_TIME','Expected Out Time','Expected Out Time','Uitgestelde tyd', 'Thời gian chờ dự kiến',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PERSON_TO_MEET')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','PERSON_TO_MEET','Person for Meet','Person for Meet','Persoon vir ontmoet', 'Người gặp gỡ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='REASON_FOR_VISIT')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','REASON_FOR_VISIT','Reason for Visit','Reason for Visit','Rede vir besoek', 'Lý do ghé thăm',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='VISIT_STATUS')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','VISIT_STATUS','Visit Status','Visit Status','Besoek status', 'Truy cập trạng thái',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='VISIT_TIME')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','VISIT_TIME','Visit Time','Visit Time','Besoek Tyd', 'Thăm thời gian',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ENQUIRY_STAGE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','ENQUIRY_STAGE','Enquiry Stage','Enquiry Stage','Navorsingsfase', 'Giai đoạn điều tra',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='BOOKING_DATE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','BOOKING_DATE','Booking Date','Booking Date','Besprekingsdatum', 'Ngày đặt phòng',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='BOOKING_ID_PLACEHOLDER')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','BOOKING_ID_PLACEHOLDER','ID will be auto-generated','ID will be auto-generated','ID sal outomaties gegenereer word', 'ID sẽ được tạo tự động',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SPORT_EVENT')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','SPORT_EVENT','Sports/Event','Sports/Event','Sport byeenkoms', 'Sự kiện thể thao',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='LEVEL_EVENT')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','LEVEL_EVENT','Level/Event','Level/Event','Vlak / Event', 'Cấp độ / sự kiện',now(),1);
END IF;
 
END $$

-- Execute the stored procedure
CALL V20200729101035__InsertUITRNSForPersonPortal $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200729101035__InsertUITRNSForPersonPortal $$
 
DELIMITER ;