DELIMITER $$
DROP PROCEDURE IF EXISTS V20200812193502__UITranslation_ForDebitOrderUpdated $$
CREATE PROCEDURE V20200812193502__UITranslation_ForDebitOrderUpdated()
BEGIN

set @smId = (SELECT id FROM standard_master WHERE tableName='debit_order_date');

IF  EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId=@smId and fieldLabel ='ITEM_CODE')) THEN 

    SET SQL_SAFE_UPDATES = 0;
    UPDATE standard_master_items SET fieldLabel='DAY_OF_MONTH' 
    where standardMasterId = @smId AND fieldLabel='ITEM_CODE';
    SET SQL_SAFE_UPDATES = 1;

END IF; 


IF  EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId=@smId and fieldLabel ='ITEM_VALUE')) THEN 

    SET SQL_SAFE_UPDATES = 0;
    UPDATE standard_master_items SET fieldLabel='TEXT_VALUE' 
    where standardMasterId = @smId AND fieldLabel='ITEM_VALUE';
    SET SQL_SAFE_UPDATES = 1;

END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'DAY_OF_MONTH' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','DAY_OF_MONTH','Day of Month','Day of Month','Ngày trong tháng','Dag van die maand',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'TEXT_VALUE' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','TEXT_VALUE','Text Value','Text Value','Giá trị văn bản','Tekswaarde',now(),1);
END IF; 



END $$
CALL V20200812193502__UITranslation_ForDebitOrderUpdated() $$
DROP PROCEDURE IF EXISTS V20200812193502__UITranslation_ForDebitOrderUpdated $$
DELIMITER ;
