DELIMITER $$
DROP PROCEDURE IF EXISTS V20200825102050__InsertDataGridSelectionSnapshot $$
CREATE PROCEDURE V20200825102050__InsertDataGridSelectionSnapshot()
BEGIN

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.admission.applications.applicantProfileBase.SelectionSnapshotGrid' AND portalId = 6 )) THEN 
INSERT INTO `data_grid`
(
`gridName`,
`portalId`,
`jsonObject`,
`lastUpdate`,
`lastUpdatedBy`)
VALUES
(
'Academia.view.admission.applications.applicantProfileBase.SelectionSnapshotGrid',
6,
'[
 {"id":null,"columnName":"ACADEMY","dataIndex":"academy.value","columnVisibility":"SHOW","sequence":1,"mandatory":false},
 {"id":null,"columnName":"LOCATION","dataIndex":"location.value","columnVisibility":"SHOW","sequence":2,"mandatory":false},
 {"id":null,"columnName":"PROGRAM","dataIndex":"program.value","columnVisibility":"SHOW","sequence":3,"mandatory":false},
 {"id":null,"columnName":"BATCH","dataIndex":"batch.value","columnVisibility":"SHOW","sequence":4,"mandatory":false},
 {"id":null,"columnName":"SEAT_TYPE","dataIndex":"seatType.value","columnVisibility":"SHOW","sequence":5,"mandatory":false},
 {"id":null,"columnName":"SELECTION_PROCESS","dataIndex":"selectionProcess.value","columnVisibility":"SHOW","sequence":6,"mandatory":false},
 {"id":null,"columnName":"PROGRAM_STATUS","dataIndex":"currentStatus","columnVisibility":"SHOW","sequence":7,"mandatory":false},
 {"id":null,"columnName":"OFFER_LETTER","dataIndex":"offerLetterIssuedFileName","columnVisibility":"SHOW","sequence":8,"mandatory":false}
 ]',now(),
1);
END IF; 


IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.personinfo.common.pasthistory.EducationHistoryGrid' and portalId=6)) THEN 
INSERT INTO `data_grid`
(
`gridName`,
`portalId`,
`jsonObject`,
`lastUpdate`,
`lastUpdatedBy`)
VALUES
(
'Academia.view.personinfo.common.pasthistory.EducationHistoryGrid',
6,
'[
  {"id":null,"columnName":"EXAM_PASSED","dataIndex":"examPassed","columnVisibility":"SHOW","sequence":1,"mandatory":false},
  {"id":null,"columnName":"EXAM_BOARD","dataIndex":"examBoard","columnVisibility":"SHOW","sequence":2,"mandatory":false},
  {"id":null,"columnName":"EXAM_CONDUCTED_BY_COLLAGE","dataIndex":"examConductedBy","columnVisibility":"SHOW","sequence":3,"mandatory":false},
  {"id":null,"columnName":"INSTITUTE_NAME","dataIndex":"instituteName","columnVisibility":"SHOW","sequence":4,"mandatory":false},
  {"id":null,"columnName":"MARKS_GRADE_OBTAINED","dataIndex":"marksOrGradeObtained","columnVisibility":"SHOW","sequence":5,"mandatory":false},
  {"id":null,"columnName":"GPA/Percentage","dataIndex":"percentage","columnVisibility":"SHOW","sequence":6,"mandatory":false},
  {"id":null,"columnName":"YEAR_OF_EXAM","dataIndex":"yearOfExamination","columnVisibility":"SHOW","sequence":7,"mandatory":false},
  {"id":null,"columnName":"RESULT_STATUS","dataIndex":"resultStatus","columnVisibility":"SHOW","sequence":8,"mandatory":false},
  {"id":null,"columnName":"ENROLLMENT_NUMBER","dataIndex":"enrollmentNumber","columnVisibility":"SHOW","sequence":9,"mandatory":false}
  ]',now(),1);
END IF; 

END $$
CALL V20200825102050__InsertDataGridSelectionSnapshot $$
DROP PROCEDURE IF EXISTS V20200825102050__InsertDataGridSelectionSnapshot $$
DELIMITER ;