DELIMITER $$
DROP PROCEDURE IF EXISTS V20200831102016__Create_employeeJobApplication $$
CREATE PROCEDURE V20200831102016__Create_employeeJobApplication()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='employee_job_application')) THEN 
CREATE TABLE `employee_job_application` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `applicantName` varchar(255) DEFAULT NULL,
  `jobTitle` varchar(255) DEFAULT NULL,
  `designation` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `staffId` bigint(20) DEFAULT NULL,
  `emailId` varchar(255) DEFAULT NULL,
  `mobileNumber` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT NULL,
  `applicationStatus` varchar(45) DEFAULT NULL,
  `applicationStatusDate` datetime DEFAULT NULL,
  `jobPostingId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_emp_job_app_staff_idx` (`staffId`),
  KEY `fk_emp_job_app_lastUpdatedBy_idx` (`lastUpdatedBy`),
  KEY `fk_emp_job_app_job_posting_idx` (`jobPostingId`),
  CONSTRAINT `fk_emp_job_app_job_posting` FOREIGN KEY (`jobPostingId`) REFERENCES `employee_job_posting` (`id`),
  CONSTRAINT `fk_emp_job_app_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_emp_job_app_staff` FOREIGN KEY (`staffId`) REFERENCES `staffs` (`userid`)
);



END IF; 

END $$
CALL V20200831102016__Create_employeeJobApplication () $$ 
DROP PROCEDURE IF EXISTS V20200831102016__Create_employeeJobApplication $$ 
DELIMITER ;