DROP PROCEDURE IF EXISTS proc_Caste_Category;

DELIMITER //
CREATE PROCEDURE proc_Caste_Category(IN p_admission_ID int,IN p_user_status int,
IN p_program_id int, IN p_batch_id int,IN c_Course_id int,IN p_courseVariant_id int,
IN p_intake_year_ID int,IN p_academy_location_id varchar(500),p_section_id varchar(500))

BEGIN



if p_admission_ID is null and c_Course_id is null and p_courseVariant_id is null and p_intake_year_ID is null and p_academy_location_id is null and p_section_id is null


 then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null


group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
order by tab1.Program_name  ;

end if;



if p_admission_ID is not null and c_Course_id is null and p_courseVariant_id is null and p_intake_year_ID is null and p_academy_location_id is null and p_section_id is null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  adm.id =p_admission_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;


end if;

if p_admission_ID is not null and c_Course_id is not null and p_courseVariant_id is null and p_intake_year_ID is null and p_academy_location_id is null  and p_section_id is null

then 

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  adm.id =p_admission_ID and c.id=c_Course_id and  ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and c.id=c_Course_id  and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;

if p_admission_ID is not null and c_Course_id is not null and p_courseVariant_id is not null and p_intake_year_ID is null and p_academy_location_id is null and p_section_id is null

then
select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;

if p_admission_ID is not null and c_Course_id is not null and p_courseVariant_id is not null and p_intake_year_ID is not null and p_academy_location_id is null and p_section_id is null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;

if p_admission_ID is not null and c_Course_id is not null and p_courseVariant_id is not null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is null

then 

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;

if p_admission_ID is  null and c_Course_id is not null and p_courseVariant_id is null and p_intake_year_ID is null and p_academy_location_id is null and p_section_id is null
then 
select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  c.id=c_Course_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where c.id=c_Course_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;

if p_admission_ID is  null and c_Course_id is not null and p_courseVariant_id is not null and p_intake_year_ID is null and p_academy_location_id is null and p_section_id is null
then 
select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  c.id=c_Course_id and b.id=p_courseVariant_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where c.id=c_Course_id and b.id=p_courseVariant_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;
end if;

if p_admission_ID is  null and c_Course_id is not null and p_courseVariant_id is not null and p_intake_year_ID is not null and p_academy_location_id is null and p_section_id is null
then 

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;


if p_admission_ID is  null and c_Course_id is not null and p_courseVariant_id is not null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is null
then 

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null


group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null



group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;


end if;

if p_admission_ID is null  and c_Course_id is  null and p_courseVariant_id is not null and p_intake_year_ID is null and p_academy_location_id is null and p_section_id is null
then 

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  b.id=p_courseVariant_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where b.id=p_courseVariant_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;


end if;

if p_admission_ID is null  and c_Course_id is  null and p_courseVariant_id is not null and p_intake_year_ID is not null and p_academy_location_id is null and p_section_id is null
then 

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;


end if;


if p_admission_ID is  null and c_Course_id is null and p_courseVariant_id is not null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is null
then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;

if p_admission_ID is  null and c_Course_id is  null and p_courseVariant_id is  null and p_intake_year_ID is not null and p_academy_location_id is null and p_section_id is null
then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;

if p_admission_ID is  null and c_Course_id is  null and p_courseVariant_id is  null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is null
then
select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;

if p_admission_ID is  null and c_Course_id is  null and p_courseVariant_id is  null and p_intake_year_ID is  null and p_academy_location_id is not null and p_section_id is null
then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null


group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;



if p_admission_ID is  null and c_Course_id is not null and p_courseVariant_id is  null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  c.id=c_Course_id  and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where c.id=c_Course_id  and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;


if p_admission_ID is  null and c_Course_id is not null and p_courseVariant_id is  null and p_intake_year_ID is  null and p_academy_location_id is not null and p_section_id is null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  c.id=c_Course_id  and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where c.id=c_Course_id  and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;


if p_admission_ID is  null and c_Course_id is not null and p_courseVariant_id is not  null and p_intake_year_ID is  null and p_academy_location_id is not null and p_section_id is null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where  c.id=c_Course_id and b.id=p_courseVariant_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where c.id=c_Course_id and b.id=p_courseVariant_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;




if p_admission_ID is not null and c_Course_id is not null and p_courseVariant_id is not  null and p_intake_year_ID is  null and p_academy_location_id is not null and p_section_id is null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and  c.id=c_Course_id and b.id=p_courseVariant_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and  c.id=c_Course_id and b.id=p_courseVariant_id and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;



if p_admission_ID is not null and c_Course_id is null and p_courseVariant_id is not  null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and   b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and   b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;




if p_admission_ID is not null and c_Course_id is not null and p_courseVariant_id is   null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and   c.id=c_Course_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and   c.id=c_Course_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;



if p_admission_ID is not null and c_Course_id is  null and p_courseVariant_id is   null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and    ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and    ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;



if p_admission_ID is not null and c_Course_id is  null and p_courseVariant_id is   null and p_intake_year_ID is  null and p_academy_location_id is not null and p_section_id is null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and    ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and    ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;






if p_admission_ID is not null and c_Course_id is not null and p_courseVariant_id is not null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is not null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;


if p_admission_ID is  null and c_Course_id is not null and p_courseVariant_id is not null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is not null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where c.id=c_Course_id and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;


if p_admission_ID is not null and c_Course_id is  null and p_courseVariant_id is not null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is not null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where 
adm.id =p_admission_ID and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where 
adm.id =p_admission_ID and b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;


if p_admission_ID is not null and c_Course_id is not null and p_courseVariant_id is  null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is not null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where
adm.id =p_admission_ID and c.id=c_Course_id  and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)
where 
adm.id =p_admission_ID and c.id=c_Course_id  and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;



if p_admission_ID is not null and c_Course_id is not null and p_courseVariant_id is not null and p_intake_year_ID is  null and p_academy_location_id is not null and p_section_id is not null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where
adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and  ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)
where 
adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and  ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;


if p_admission_ID is not null and c_Course_id is not null and p_courseVariant_id is not null and p_intake_year_ID is  null and p_academy_location_id is  null and p_section_id is not null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where
adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and  ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id  and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)
where 
adm.id =p_admission_ID and c.id=c_Course_id and b.id=p_courseVariant_id and  ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id  and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;



if p_admission_ID is  null and c_Course_id is  null and p_courseVariant_id is not null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is not null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where
b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)
where 
b.id=p_courseVariant_id and ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;



if p_admission_ID is  null and c_Course_id is  null and p_courseVariant_id is  null and p_intake_year_ID is not null and p_academy_location_id is not null and p_section_id is not null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where
ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)
where 
ir.id=p_intake_year_ID and ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;


if p_admission_ID is  null and c_Course_id is  null and p_courseVariant_id is  null and p_intake_year_ID is null and p_academy_location_id is not null and p_section_id is not null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where
ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)
where 
ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(al.id,p_academy_location_id) and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;


if p_admission_ID is  null and c_Course_id is  null and p_courseVariant_id is  null and p_intake_year_ID is null and p_academy_location_id is  null and p_section_id is not null

then

select distinct tab1.GradeName,tab1.gradeRange,tab1.category,tab1.religion,tab1.gender,tab1.genderCount,
tab1.Program_name,tab1.AcademyLocation,tab1.Cource_name,tab2.Section_Name,tab2.faculty
 from (select  distinct g.GradeName,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%') as gradeRange,
cast.itemValue as category,cc.itemCode as religion,
gen.itemValue as gender , sum(case when a.grade=g.gradename then 1 else 0 end) as genderCount,
prog.programNameToBePrint as Program_name,al.displayName as AcademyLocation,
c.nameToBePrinted Cource_name,prog.id as prog_id,btc.id as btc_id
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)

where
ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null


group by g.Gradename,concat(g.gradeRangeFrom,'% To ',g.gradeRangeTo,'%'),
cast.itemValue,cc.itemCode ,
gen.itemValue  ,
prog.programNameToBePrint,al.displayName ,
c.nameToBePrinted,prog.id,btc.id
order by c.nameToBePrinted desc ) tab1,
(

select  
 distinct group_concat(distinct sec.alternateName) as Section_Name,
group_concat(distinct usrr.printName) as faculty,
prog.id as prog_id2,btc.id as btc_id2
from evaluation_plan_rank a
 inner join  admission adm on (a.admissionid=adm.id)
 inner join prog_batch_period_config period on (a.periodId = period.id)
 inner join batches btc on btc.id = period.programbatchId
 inner join programs prog on prog.id = btc.programid
 inner join academy_location al on (prog.academyLocationId=al.id)
inner join course_variants b on( a.courseVariantId=b.id )
inner join courses c on(b.courseId=c.id)
right join grade g on(c.courseGradeType=g.gradeType)
left join program_batch_students pbs on(pbs.admissionId = a.admissionId and pbs.progBatchPeriodConfigId = a.periodId and pbs.sectionId is not null)
left join intake_year ir on(btc.intakeYearId=ir.id)
left join students stu on(adm.studentId=stu.userId )
left join  persons prs on (stu.personId=prs.id)
left join caste_categories cast on(cast.id=prs.castCategoryid)
left join religions cc on (prs.religionId=cc.id)
left join gender gen on(prs.genderId=gen.id)
left join users ur on(stu.userId=ur.id)
left join sections sec on(pbs.sectionId=sec.id )
left join staffs stf on(sec.facultyId=stf.userId)
left join users usrr on(stf.userId=usrr.id)
where 
ur.status=p_user_status and prog.id=p_program_id and
btc.id=p_batch_id and FIND_IN_SET(sec.id,p_section_id) and cast.itemValue is not null

group by prog.id,btc.id) tab2 where
 tab1.prog_id=tab2.prog_id2 and tab1.btc_id=tab2.btc_id2
 
 order by tab1.Program_name ;

end if;




END //
DELIMITER ;

