DELIMITER $$
DROP PROCEDURE IF EXISTS V20200921172609__Insert_D5_Report $$
CREATE PROCEDURE V20200921172609__Insert_D5_Report()
BEGIN

	
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'D5_ASSESSMENT_REPORT' )) THEN 
set @reportName1 = (select id from report_type WHERE typeName = 'Examination Foils Report');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES (@reportName1, 'D5_ASSESSMENT_REPORT', 'D-5 Assessment report', 'D5_ASSESSMENT_REPORT.png', 'D5_CommonReport_PageNumber.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'D5_ASSESSMENT_REPORT.jasper', 'AcademiaLogo.png'); 


set @d5ID = (select id from report_template where templateCode ='D5_ASSESSMENT_REPORT');
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_PROGRESSIVE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_PROGRESSIVE', 'PROGRESSIVE ASSESSMENT OF THEORY', '1', now());
 END IF;
 
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_ACADEMIC_Y')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_ACADEMIC_Y', 'Academic Year:', '1', now());
 END IF;
 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_PROGRAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_PROGRAM', 'Program:', '1', now());
 END IF;	

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_COURSE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_COURSE', 'Course:', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_COURSE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_COURSE_CODE', 'Course Code:', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_COURSE_CODE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_COURSE_CODE_NAME', 'Course Code & Name', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_SEMESTER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_SEMESTER', 'Semester:', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_FACULTY_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_FACULTY_NAME', 'Name of Faculty:', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_ROLLNO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_ROLLNO', 'Roll No.', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_STD_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_STD_NAME', 'Name of Student', '1', now());
 END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_ENROLLMENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_ENROLLMENT', 'Enrolment No.', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_EXAM_SEATNO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_EXAM_SEATNO', 'Exam Seat No.', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_OUTOF')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_OUTOF', '(Out of 30)', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_TOTAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_TOTAL', 'Total of (7+8+9)', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_SIGN_FACULTY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_SIGN_FACULTY', '(Name & Signature of Faculty)', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d5ID and keyValue='TRANS_SIGN_HOD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d5ID, 'TRANS_SIGN_HOD', '(Name & Signature of HOD)', '1', now());
 END IF;

END IF;

END $$
CALL V20200921172609__Insert_D5_Report() $$
DROP PROCEDURE IF EXISTS V20200921172609__Insert_D5_Report $$
DELIMITER ;
