DELIMITER $$
DROP PROCEDURE IF EXISTS V20201026100512__Update_TriggersForParentGuardianPnC $$
CREATE PROCEDURE V20201026100512__Update_TriggersForParentGuardianPnC()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='sql_dtprovider' AND column_name='sqlQuery')) THEN 
 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_FATHER_PRESENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'FATHER' " WHERE `dataProviderId`=@dtproviderId;
    
 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_MOTHER_PRESENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'MOTHER' " WHERE `dataProviderId`=@dtproviderId;

 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_COURSEWISE_WEEKLY_ATTENDANCE_PARENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T13.id AS ID,   
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T16.code AS STUDENT_CODE,
    T13.firstName AS PARENT_FIRST_NAME,
    T13.lastName AS PARENT_LAST_NAME,
    T13.emailId AS EMAIL_ID,
    T13.mobileNumber AS MOBILE_NO,
    T13.mobilecountrycode AS MOBILE_CODE,
    cou.nameToBePrinted AS COURSE_NAME,
    cou.courseCode AS COURSE_CODE,   
    T9.firstName AS FACULTY_FIRSTNAME,
    T9.lastName AS FACULTY_LASTNAME,
    T10.salutationName AS SALUTATION,
    T15.salutationName AS PARENT_SALUTATION,
    bch.batchName AS BATCH_NAME,
    prg.programNameToBePrint AS PROGRAM_NAME,
    per.programPeriodName AS PERIOD_NAME,
    T18.displayName AS ACADEMY_NAME,    
	ml.`code` as LANGUAGE_KEY,
    COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_SESSIONS`,
    COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_PRESENT`,
    COUNT(IF(scad.attendanceStatus = 'ABSENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_ABSENT`,
    COUNT(IF(scad.attendanceStatus = 'LEAVE',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_LEAVE`,
    ROUND((COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) / (COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
                scad.attendanceStatus,
                NULL)))) * 100) AS `PRESENT_PERCENTAGE`
                from student_course_enrollment sce
join prog_batch_period_config per 
on per.id = sce.programBatchPeriodConfigId
join admission adm 
on adm.id = sce.admissionId
join batches bch on bch.id = per.programBatchId
join programs prg on prg.id=  bch.programId
join course_variants cv on cv.id = sce.courseVarientId
join courses cou on cou.id = cv.courseId or cou.parentCourseId = cv.courseId
join program_batch_course_param param on param.courseVarientId = cv.id
join prog_batch_course_faculty fac on fac.progBatchCourseParamId =  param.id
left join student_course_attendance sca on sca.variantId = sce.courseVarientId
left join student_course_attendance_details scad on scad.attendanceId = sca.id and adm.id = scad.admissionId
LEFT JOIN
	users T16 ON T16.id = adm.studentId
LEFT JOIN
    students T6 ON T6.userId = T16.id
        LEFT JOIN
    persons T7 ON T7.id = T6.personId
        LEFT JOIN
    staffs T8 ON T8.userId = fac.facultyId
        LEFT JOIN
    persons T9 ON T9.id = T8.personId
        LEFT JOIN
    salutations T10 ON T10.id = T9.salutationId
        LEFT JOIN
    person_relationships T12 ON T12.personId = T7.id
        LEFT JOIN
    persons T13 ON T13.id = T12.relatedPersonId
		LEFT JOIN
    salutations T15 ON T15.id = T13.salutationId
        LEFT JOIN
    academy_location T18 ON T18.id = prg.academyLocationId
     LEFT JOIN
     multi_language ml ON ml.id = T7.correspondence_language
where (T13.isDeceased is null OR T13.isDeceased=FALSE) AND per.isCurrentPeriodOfProgram = 1 and T13.id IN (namedParams)
and sce.exitDate is null
GROUP BY cv.courseId , sce.sectionId , sce.courseVarientId , adm.studentId,T13.id
ORDER BY cv.courseId DESC  " WHERE `dataProviderId`=@dtproviderId;


SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_DAY_WISE_FATHER_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'FATHER' AND T6.whetherDeleted = false " WHERE `dataProviderId`=@dtproviderId;


SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_DAY_WISE_MOTHER_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'MOTHER' AND T6.whetherDeleted = false " WHERE `dataProviderId`=@dtproviderId;


END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20201026100512__Update_TriggersForParentGuardianPnC () $$
DROP PROCEDURE IF EXISTS V20201026100512__Update_TriggersForParentGuardianPnC $$
DELIMITER ;