DELIMITER $$
DROP PROCEDURE IF EXISTS V20201119190214__Create_appointment_details_view $$
CREATE PROCEDURE V20201119190214__Create_appointment_details_view()
BEGIN

IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'appointment_details_view')) THEN 
DROP view `appointment_details_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'appointment_details_view')) THEN 
CREATE OR REPLACE view appointment_details_view as
select
enq.code as Lead_id,enq.enquiryDate as Lead_Date,
enqstu.studentFirstName,enqstu.studentMiddleName,
concat(enqstu.studentFirstName,' ',enqstu.studentMiddleName,' ',enqstu.studentLastName) as Student_Name,
al.academyCode,al.academyName,al.locationCode,al.locationName,modeod.itemValue as Mode_of_Delivery,
case when batch.batchPartTime = 1 then 'Part Time'  when batch.batchPartTime=0 then 'Full Time' else null end as Registration_Type,
prog.programCode,prog.programnametobeprint as Program_Name,prog.programShortName,
batch.printname as Intake,iy.itemValue as Intake_Year,
usr.printName as Lead_Owner,case when enq.status='O' then 'Open' when enq.status='C' then 'Closed' else null end as Enquiry_Status,
enqinter.type as Enquiry_Stage,enqp.priority,
asd.Appointment_ID,asd.appointeeName,asd.reasonToVisit as Reason_To_Meet,asd.personToMeet as Person_To_Meet,
asd.appointmentDate,asd.Appointment_Type,asd.Appointment_Owner,asd.Appointment_Status,
asd.Application_Code,asd.StudentID,asd.visitTime,asd.Out_Time

 from enquiry enq left join enquiry_type enqty on(enq.enquiryTypeId=enqty.id)
 left join academy_location al on(enq.academyLocationId=al.id)
 left join enq_student_details enqstu on(enq.id=enqstu.enquiryId)
 left join admission_enq_details admenq  on(admenq.enqStudentDetailsId=enqstu.id)
 left join batches batch on (admenq.batchId=batch.id)
left join intake_year iy on(batch.intakeYearId=iy.id)
 left join mode_of_delivery modeod on(batch.modeOfDeliveryId=modeod.id)
 left join users usr on(enq.userId =usr.id)
  left join enq_priority enqp on(enq.enqPriorityId=enqp.id)
 left join programs prog on(admenq.programId=prog.id)
 left join enq_intermediate_type enqinter on(enq.enqIntermediateStageId=enqinter.id)
right join
 (select enq1.id,appl.id as applicationid,sga.id as Appointment_ID,sga.appointeeName,sga.reasonToVisit,sga.personToMeet,
max(appointmentDate) as appointmentDate,sgr.reasonForVisit as Appointment_Type,usrk.printName as Appointment_Owner
,sgv.itemValue as Appointment_Status,appl.code as Application_Code,
sga.StudentID,sga.visitTime,sga.expectedOutTime as Out_Time
 from sg_appointment sga left join
enquiry enq1  on(enq1.id=sga.enquiryid)
 left join sg_reason_for_visit sgr on(sga.reasonForVisitId=sgr.id)
 left join sg_visit_status sgv on(sga.visitStatusId=sgv.id)
left join users usrk on (usrk.id=sga.personToMeetId)
left join application appl on (sga.applicationId=appl.id)
 group by sga.enquiryid,appl.id ) asd on (enq.id=asd.id)
  group by asd.id;
END IF; 

END $$
CALL V20201119190214__Create_appointment_details_view () $$ 
DROP PROCEDURE IF EXISTS V20201119190214__Create_appointment_details_view $$ 
DELIMITER ;