DELIMITER $$
DROP PROCEDURE IF EXISTS V20201119190726__Create_sales_appointment_target_view $$
CREATE PROCEDURE V20201119190726__Create_sales_appointment_target_view()
BEGIN

IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'sales_appointment_target_view')) THEN 
DROP view `sales_appointment_target_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'sales_appointment_target_view')) THEN 
CREATE OR REPLACE view sales_appointment_target_view as 
select managetarget.academyLocationId,managetarget.academyName,managetarget.academyCode,
managetarget.locationName,managetarget.locationCode,
managetarget.intake_year,managetarget.Target_For,sum(managetarget.Total_Target) as Total_Appointment_Target,
usr.printname as Staff_Owner_Name,sum(enqdata.cnt) AS Total_Actual_Appointment

from (
select al.id as academyLocationId,al.academyName,al.academyCode,al.locationName,locationCode
,irr.itemValue as intake_year, manageTargetType as Target_For,
manage.actualTarget as Total_Target,staffId,manage.intakeYearId
from academy_location al
left join manage_target_tertiary manage on(manage.academyLocationId=al.id and manageTargetType='APPOINTMENTS')
left join intake_year ir on(manage.intakeYearId=ir.id)
left join programs prog on(prog.academyLocationId=al.id)
left join batches btc on(btc.programid=prog.id)
join intake_year irr on(btc.intakeYearId=irr.id)
group by academyName,locationCode,manageTargetType,staffId
) managetarget left join
(select
        count(  this_.id) as cnt,
       this_.personToMeetid,max(intakeyear7_.id) as intakeYearId ,this_.academylocationid
   from
       sg_appointment this_
   left outer join
       application applicatio3_
           on this_.applicationId=applicatio3_.id
   left outer join
       application_program applicatio4_
           on applicatio3_.id=applicatio4_.applicationId
   left join
       prog_batch_seat_config programbat5_
           on applicatio4_.progBatchSeatConfigId=programbat5_.id
   left join
       batches batch6_
           on programbat5_.programBatchId=batch6_.id
   left outer join
       intake_year intakeyear7_
           on batch6_.intakeYearId=intakeyear7_.id
     
      group by this_.personToMeetid,this_.academylocationid) enqdata

on(managetarget.intakeYearId= enqdata.intakeYearId and
managetarget.academyLocationId=enqdata.academylocationid
and managetarget.staffId=enqdata.personToMeetid)
left join users usr on(managetarget.staffId=usr.id)
group by managetarget.academyName,managetarget.locationCode,usr.id;
END IF; 

END $$
CALL V20201119190726__Create_sales_appointment_target_view () $$ 
DROP PROCEDURE IF EXISTS V20201119190726__Create_sales_appointment_target_view $$ 
DELIMITER ;