DELIMITER $$
DROP PROCEDURE IF EXISTS V20201204111728__Create_EnquiryExamBoardSubject $$
CREATE PROCEDURE V20201204111728__Create_EnquiryExamBoardSubject()
BEGIN

	IF NOT EXISTS (( SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='enquiry_student_examboard_subject')) THEN 
		CREATE TABLE `enquiry_student_examboard_subject` (
		  `id` bigint(20) NOT NULL AUTO_INCREMENT,
		  `subjectId` BIGINT(20) NOT NULL,
		  `enquiryStudentDetailId` BIGINT(20) NOT NULL,
		  `lastUpdatedBy` bigint(20) DEFAULT NULL,
		  `lastUpdate` datetime NOT NULL,
		  PRIMARY KEY (`id`),
		  KEY `fk_enquiry_student_examboard_subject_subjectId` (`subjectId`),
		  KEY `fk_enquiry_student_examboard_subject_enqStdDetailId` (`enquiryStudentDetailId`),
		  KEY `fk_enquiry_student_examboard_subject_lastUpdatedBy` (`lastUpdatedBy`),
		  CONSTRAINT `fk_enquiry_student_examboard_subject_subjectId` FOREIGN KEY (`subjectId`) REFERENCES `subjects` (`id`),
		  CONSTRAINT `fk_enquiry_student_examboard_subject_enqStdDetailId` FOREIGN KEY (`enquiryStudentDetailId`) REFERENCES `enq_student_details` (`id`),
		  CONSTRAINT `fk_enquiry_student_examboard_subject_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
		  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	END IF; 

END $$
CALL V20201204111728__Create_EnquiryExamBoardSubject () $$ 
DROP PROCEDURE IF EXISTS V20201204111728__Create_EnquiryExamBoardSubject $$ 
DELIMITER ;