DELIMITER $$

DROP PROCEDURE IF EXISTS V20210107163421__InsertTransforPortalInfo $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20210107163421__InsertTransforPortalInfo()

BEGIN
 
  -- Insert new record in ui_translation table, if it doesn't already exist
    IF NOT EXISTS (((select * from ui_translation where objectName = 'PORTAL_SETUP_NEW' and keyName = 'IS_AGENCY_RECRUITED'))) THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
                VALUES ('PORTAL_SETUP_NEW', 'IS_AGENCY_RECRUITED', 'Is Agency Recruited', 'Is Agency Recruited', 'Is agentskap gewerf', 'Đại lý được tuyển dụng',now(),1);
    END IF;
    
    IF NOT EXISTS (((select * from ui_translation where objectName = 'PORTAL_SETUP_NEW' and keyName = 'POST_NUMBER'))) THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
                VALUES ('PORTAL_SETUP_NEW', 'POST_NUMBER', 'Post Number', 'Post Number', 'Posnommer', 'Số bài viết',now(),1);
    END IF;
    
    IF NOT EXISTS (((select * from ui_translation where objectName = 'PORTAL_SETUP_NEW' and keyName = 'HPCSA_REG_NO'))) THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
                VALUES ('PORTAL_SETUP_NEW', 'HPCSA_REG_NO', 'HPCSA Registration Number', 'HPCSA Registration Number', 'HPCSA-registrasienommer', 'Số đăng ký HPCSA',now(),1);
    END IF;
    
     IF NOT EXISTS (((select * from ui_translation where objectName = 'TRANSLATIONS' and keyName = 'PLEASE_ENTER_SEQUENCE'))) THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
                VALUES ('TRANSLATIONS', 'PLEASE_ENTER_SEQUENCE', 'Please Enter Sequence', 'Please Enter Sequence', 'Voer gerus in', 'Vui lòng nhập trình tự',now(),1);
    END IF;

END $$


-- Execute the stored procedure
CALL V20210107163421__InsertTransforPortalInfo() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20210107163421__InsertTransforPortalInfo $$
 
DELIMITER ;