DELIMITER $$
DROP PROCEDURE IF EXISTS V20210107163642__Alter_AppEdHistoryAddAddressFields $$
CREATE PROCEDURE V20210107163642__Alter_AppEdHistoryAddAddressFields()

BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='applicant_education_histories' AND column_name='country_id')) THEN 
	ALTER TABLE `applicant_education_histories` 
	ADD COLUMN `country_id` BIGINT(20) NULL DEFAULT NULL after education_department_id,
	ADD CONSTRAINT `fk_applicant_education_histories_country_id` 
	FOREIGN KEY (`country_id`) REFERENCES `country` (`id`);
	END IF; 
	
	
	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='applicant_education_histories' AND column_name='country_region_id')) THEN 
	ALTER TABLE `applicant_education_histories` 
	ADD COLUMN `country_region_id` BIGINT(20) NULL DEFAULT NULL after country_id,
	ADD CONSTRAINT `fk_applicant_education_histories_country_region_id` 
	FOREIGN KEY (`country_region_id`) REFERENCES `country_region` (`id`);
	END IF; 
	
	
	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='applicant_education_histories' AND column_name='city_id')) THEN 
	ALTER TABLE `applicant_education_histories` 
	ADD COLUMN `city_id` BIGINT(20) NULL DEFAULT NULL after country_region_id,
	ADD CONSTRAINT `fk_applicant_education_histories_city_id` 
	FOREIGN KEY (`city_id`) REFERENCES `city` (`id`);
	END IF; 

END $$

CALL V20210107163642__Alter_AppEdHistoryAddAddressFields() $$
DROP PROCEDURE IF EXISTS V20210107163642__Alter_AppEdHistoryAddAddressFields $$
DELIMITER ;