DELIMITER $$
DROP PROCEDURE IF EXISTS V20210222122118__Create_views_for_vgu_client $$
CREATE PROCEDURE V20210222122118__Create_views_for_vgu_client()
BEGIN

DROP VIEW IF EXISTS Scholarship_Master_details;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='Scholarship_Master_details')) THEN 
	CREATE VIEW Scholarship_Master_details AS
    SELECT DISTINCT
        sch.scholarshipCode AS Scholarship_ID,
        sch.scholarshipname,
        scholarshiptype,
        schor.organizationName,
        validityinmonth AS validity
    FROM
        scholarship sch
            LEFT JOIN
        scholarship_organizations schor ON (sch.scholarshiporganizationid = schor.id);

END IF; 


DROP VIEW IF EXISTS Program_Intake_details;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='Program_Intake_details')) THEN 
	CREATE VIEW Program_Intake_details AS
    SELECT DISTINCT
        prog.programcode AS Study_Program_Code,
        btc.batchName AS Intake,
        ir.itemValue AS Intake_Year,
        btc.seatCapacity,
        btc.startDate,
        btc.tillDate
    FROM
        batches btc
            JOIN
        programs prog ON (prog.id = btc.programId)
            JOIN
        intake_year ir ON (ir.id = btc.intakeyearid);

END IF; 

DROP VIEW IF EXISTS studyprogram_details;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='studyprogram_details')) THEN 
	CREATE VIEW studyprogram_details AS
    SELECT DISTINCT
        al.academyCode AS Faculty_Code,
        prog.programcode AS Study_Program_Code,
        prog.programname AS Study_Program_Name,
        pg.groupname AS Study_Program_Group,
        prog.programmarkgrade AS Study_Program_Marks_Grades,
        mode.itemValue AS Mode_of_Delivery,
        CASE
            WHEN prog.status = 'O' THEN 'Open'
            WHEN prog.status = 'C' THEN 'Close'
            ELSE prog.status
        END status
    FROM
        programs prog
            JOIN
        academy_location al ON (al.id = prog.academyLocationId)
            JOIN
        program_group pg ON (pg.id = prog.programgroupid)
            LEFT JOIN
        mode_of_delivery mode ON (mode.id = prog.modeofdeliveryid);

END IF; 

DROP VIEW IF EXISTS Scholarship_Awardee_details;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='Scholarship_Awardee_details')) THEN 
	CREATE VIEW Scholarship_Awardee_details AS
    SELECT DISTINCT
        usr.code AS Student_ID,
        usr.printname AS student_name,
        prog.programname AS program,
        btc.batchname AS Intake,
        pbpc.printname AS Semester,
        sch.scholarshipname,
        schawd.awardedon AS Award_Date,
        schawd.appliedOn AS Applied_Date,
        schawd.validFrom,
        schawd.validUpto AS Valid_Till
    FROM
        scholarship_awardees schawd
            LEFT JOIN
        users usr ON (usr.id = schawd.studentId)
            LEFT JOIN
        programs prog ON (schawd.programid = prog.id)
            LEFT JOIN
        batches btc ON (btc.programid = prog.id)
            LEFT JOIN
        prog_batch_period_config pbpc ON (pbpc.programbatchid = btc.id)
            LEFT JOIN
        scholarship sch ON (sch.id = schawd.scholarshipid);

END IF; 

DROP VIEW IF EXISTS faculty_details;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='faculty_details')) THEN 
	CREATE VIEW faculty_details AS
    SELECT DISTINCT
        al.academyCode AS Faculty_Code,
        aca.academyName AS Faculty_Name,
        aca.startDate,
        aca.tillDate,
        aca.status
    FROM
        academies aca
            JOIN
        academy_location al ON (al.academyId = aca.id);

END IF; 

DROP VIEW IF EXISTS event_details;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='event_details')) THEN 
	CREATE VIEW event_details AS
    SELECT DISTINCT
        rb.id AS Event_ID,
        rb.eventName AS Event_Name,
        rb.eventDate,
        bp.value AS Event_purpose,
        rb.venue,
        rb.purpose AS Purpose_Detail,
        rb.eventDesc AS Event_Description,
        rb.bookedBy
    FROM
        resource_bookings rb
            JOIN
        booking_purposes bp ON (bp.id = rb.bookingPurposeId);

END IF; 

DROP VIEW IF EXISTS Program_Intake_Semester_details;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='Program_Intake_Semester_details')) THEN 
	CREATE VIEW Program_Intake_Semester_details AS
    SELECT DISTINCT
        prog.programCode AS Study_Program_Code,
        btc.batchName AS Intake,
        pbpc.programPeriodSeq AS Study_Program_Semester_Sequence,
        pbpc.programPeriodName AS Study_Program_Semester_Name,
        pbpc.printName,
        at.itemValue AS Academic_Term,
        pbpc.programPeriodStart AS Semester_Start_Date,
        pbpc.programPeriodEnd AS Semester_End_Date
    FROM
        prog_batch_period_config pbpc
            JOIN
        batches btc ON (btc.id = pbpc.programBatchId)
            JOIN
        programs prog ON (btc.programId = prog.id)
            JOIN
        academic_term at ON (at.id = pbpc.academicTermId);

END IF; 

DROP VIEW IF EXISTS Workforce_details;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='Workforce_details')) THEN 
	CREATE VIEW Workforce_details AS
    SELECT DISTINCT
        usr.code AS Workforce_ID,
        usr.firstName,
        usr.middleName,
        usr.lastName,
        gen.itemValue AS gender,
        nat.itemValue AS Nationality,
        des.itemValue AS Designation,
        dept.deptName AS Department,
        stf.joiningDate AS Date_of_Joining,
        stf.exitDate AS Date_of_Exit,
        ug.userGroupName AS Group_Name,
        CASE
            WHEN ug.userGroupName IN ('lecturer' , 'faculty') THEN 'true'
            ELSE 'False'
        END AS Whether_Lecturer,
        ft.itemValue AS Faculty_Type
    FROM
        staffs stf
            JOIN
        users usr ON (usr.id = stf.userid)
            JOIN
        persons per ON (stf.personid = per.id)
            JOIN
        gender gen ON (gen.id = per.genderId)
            JOIN
        nationalities nat ON (nat.id = per.nationalityId)
            JOIN
        designations des ON (des.id = stf.designationId)
            JOIN
        department dept ON (dept.id = stf.departmentId)
            JOIN
        user_groups ug ON (ug.id = usr.userGroupId)
            LEFT JOIN
        faculty_type ft ON (ft.id = stf.facultyTypeId);

END IF; 

DROP VIEW IF EXISTS course_view;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='course_view')) THEN 
CREATE OR REPLACE VIEW course_view AS
    SELECT 
        cou.courseName AS Name,
        cou.courseCode AS Code,
        dept.deptName AS DepartmentName,
        dept.shortCode AS DepartmentCode,
        cou.courseCredits AS Credit,
        cou.courseCode AS Code_to_printed,
        nameToBePrinted
    FROM
        (courses cou
        JOIN department dept ON ((dept.id = cou.departmentId)));

END IF; 

END $$
CALL V20210222122118__Create_views_for_vgu_client () $$ 
DROP PROCEDURE IF EXISTS V20210222122118__Create_views_for_vgu_client $$ 
DELIMITER ;
