DELIMITER $$
DROP PROCEDURE IF EXISTS V20210225152001__Alter_ProgTransSReqAddfromBatch $$
CREATE PROCEDURE V20210225152001__Alter_ProgTransSReqAddfromBatch()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='program_xfer_request_details' AND column_name in ('admissionId','fromBatchId'))) THEN 
ALTER TABLE `program_xfer_request_details` 
ADD COLUMN `admissionId` BIGINT NULL DEFAULT NULL,
ADD COLUMN `fromBatchId` BIGINT NULL DEFAULT NULL AFTER `admissionId`,
ADD INDEX `fk_ptr_detail_admisionId_idx` (`admissionId` ASC),
ADD INDEX `fk_ptrd_program_batchId_idx` (`fromBatchId` ASC);

ALTER TABLE `program_xfer_request_details` 
ADD CONSTRAINT `fk_ptrd_admissionId`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_ptrd_programbatchId`
  FOREIGN KEY (`fromBatchId`)
  REFERENCES `batches` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

END IF; 

END $$
CALL V20210225152001__Alter_ProgTransSReqAddfromBatch() $$
DROP PROCEDURE IF EXISTS V20210225152001__Alter_ProgTransSReqAddfromBatch $$
DELIMITER ;