DELIMITER $$
DROP PROCEDURE IF EXISTS V20210226141447__Create_Scholarship_fee_heads $$
CREATE PROCEDURE V20210226141447__Create_Scholarship_fee_heads()
BEGIN

IF NOT EXISTS (((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='scholarship_fee_heads'))) THEN 
CREATE TABLE `scholarship_fee_heads`(
`id` bigint(20) NOT NULL AUTO_INCREMENT,
`scholarshipId` bigint(20) DEFAULT NULL,
`feeHeadId` bigint(20) DEFAULT NULL,
`amountType` VARCHAR(50) NULL DEFAULT NULL,
`feeAmount` double(20,2) NOT NULL,
`feeHeadPercentageValue` BIGINT(20) NULL DEFAULT NULL,
`lastUpdatedBy` bigint(20) DEFAULT NULL,
`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
 PRIMARY KEY(`ID`),
KEY `Scholarship_FK_1_idx`(`scholarshipId`), 
KEY `FeeHead_FK_2_idx`(`feeHeadId`),
KEY `USER_FK_3_idx` (`lastUpdatedBy`),
CONSTRAINT `FK_scholarship_fee_heads_scholarshipId` FOREIGN KEY (`scholarshipId`) REFERENCES `scholarship`(`id`)ON DELETE NO ACTION ON UPDATE NO ACTION,
CONSTRAINT `FK_scholarship_fee-heads_feeHeadId` FOREIGN KEY (`feeHeadId`) REFERENCES `fee_heads`(`id`)ON DELETE NO ACTION ON UPDATE NO ACTION,
CONSTRAINT `fk_scholarship_fee_heads_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
)ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;  

END $$
CALL V20210226141447__Create_Scholarship_fee_heads () $$ 
DROP PROCEDURE IF EXISTS V20210226141447__Create_Scholarship_fee_heads $$ 
DELIMITER ;