DELIMITER $$
DROP PROCEDURE IF EXISTS V20210324181310__Create_ManageSubHoldCategory $$
CREATE PROCEDURE V20210324181310__Create_ManageSubHoldCategory()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='manage_sub_hold_category')) THEN 
CREATE TABLE `manage_sub_hold_category` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `holdCatId` BIGINT(20) NOT NULL,
  `subHoldCatCode` VARCHAR(255) DEFAULT NULL,
  `subHoldCatName` VARCHAR(255) DEFAULT NULL,
   `applyholdType` VARCHAR(255) DEFAULT NULL,
   `autoApplyHoldId` BIGINT(20) DEFAULT NULL,
   `autoRemoveHoldId` BIGINT(20) DEFAULT NULL,
  `isActive` BIT(1) DEFAULT NULL,
   `isAuthorizationUser` BIT(1) DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_sub_hold_category_holdCatId_idx` (`holdCatId` ASC),
   INDEX `fk_sub_hold_category_autoApplyHoldId_idx` (`autoApplyHoldId` ASC),
    INDEX `fk_sub_hold_category_autoRemoveHoldId_idx` (`autoRemoveHoldId` ASC),
  INDEX `fk_sub_hold_category_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_sub_hold_category_holdCatId_id`
    FOREIGN KEY (`holdCatId`)
    REFERENCES `manage_hold_category` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_sub_hold_category_autoApplyHoldId_id`
    FOREIGN KEY (`autoApplyHoldId`)
    REFERENCES `drool_rules` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_sub_hold_category_autoRemoveHoldId_id`
    FOREIGN KEY (`autoRemoveHoldId`)
    REFERENCES `drool_rules` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sub_hold_category_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210324181310__Create_ManageSubHoldCategory () $$ 
DROP PROCEDURE IF EXISTS V20210324181310__Create_ManageSubHoldCategory $$ 
DELIMITER ;