DELIMITER $$
DROP PROCEDURE IF EXISTS V20210702154225__CreateNSFASProvisionalFundCaps $$
CREATE PROCEDURE V20210702154225__CreateNSFASProvisionalFundCaps()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='nsfas_person_provisional_fund_cap')) THEN 
CREATE TABLE `nsfas_person_provisional_fund_cap` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `cap_type` varchar(100) DEFAULT NULL,
  `currency_code` varchar(50) DEFAULT NULL,
  `decimal_place` varchar(10) DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `nsfas_person_provisional_fund_id` bigint DEFAULT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_nsfas_provisional_fund_cap_id_idx` (`lastUpdatedBy`),
  KEY `fk_nsfas_fund_cap_provisional_fund_id_idx` (`nsfas_person_provisional_fund_id`),
  CONSTRAINT `fk_nsfas_fund_cap_provisional_fund_id` FOREIGN KEY (`nsfas_person_provisional_fund_id`) REFERENCES `nsfas_person_provisional_fund` (`id`),
  CONSTRAINT `fk_nsfas_provisional_fund_cap_lastUpdatedBy_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
  ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


END IF; 

END $$
CALL V20210702154225__CreateNSFASProvisionalFundCaps () $$ 
DROP PROCEDURE IF EXISTS V20210702154225__CreateNSFASProvisionalFundCaps $$ 
DELIMITER ;