DELIMITER $$
DROP PROCEDURE IF EXISTS V20210729145331__Insert_GNA_MasterTimeTable $$
CREATE PROCEDURE V20210729145331__Insert_GNA_MasterTimeTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'MASTER_TIME_TABLE_CODE_FACULTY_WISE' )) THEN 
set @master = (select id from report_type WHERE typeName = 'Timetable');

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'MASTER_TIME_TABLE_CODE_FACULTY_WISE')) THEN 
INSERT INTO report_template (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@master, 'MASTER_TIME_TABLE_CODE_FACULTY_WISE', 'Master Timetable - Faculty Wise', 'MASTER_TIME_TABLE_CODE_FACULTY_WISE.png', 'CommonReport_MasterTimeTableExcel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'MASTER_TIME_TABLE_CODE_FACULTY_WISE.jasper', 'AcademiaLogo.png');
END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'MASTER_TIME_TABLE_CODE_FACULTY_WISE')) THEN 
set @table1 = (select max(id) from `report_template` WHERE templateCode = 'MASTER_TIME_TABLE_CODE_FACULTY_WISE');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_TIMETABLE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_TIMETABLE', 'Master Timetable - Faculty Wise', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_FACULTY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_FACULTY', 'Faculty', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_SESSION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_SESSION', 'Session', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_DAY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_DAY', 'Day/Session', '1', now());
END IF;

END IF;


END $$
CALL V20210729145331__Insert_GNA_MasterTimeTable() $$
DROP PROCEDURE IF EXISTS V20210729145331__Insert_GNA_MasterTimeTable $$
DELIMITER ;
