DELIMITER $$
DROP PROCEDURE IF EXISTS V20210825132914__Create_PKA_Payment_term $$
CREATE PROCEDURE V20210825132914__Create_PKA_Payment_term()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_term')) THEN 
CREATE TABLE `payment_term` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `groupId` BIGINT NULL,
  `code` VARCHAR(100) NULL,
  `name` VARCHAR(100) NULL,
  `sequenceNo` BIGINT NULL,
  `lastUpdatedBy` BIGINT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `FK_paymentTerm_programG_idx` (`groupId` ASC) ,
  INDEX `FK_paymentTerm_users_idx` (`lastUpdatedBy` ASC) ,
  CONSTRAINT `FK_paymentTerm_paymentG`
    FOREIGN KEY (`groupId`)
    REFERENCES `payment_group` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `FK_paymentTerm_users`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20210825132914__Create_PKA_Payment_term () $$ 
DROP PROCEDURE IF EXISTS V20210825132914__Create_PKA_Payment_term $$ 
DELIMITER ;