DELIMITER $$
DROP PROCEDURE IF EXISTS V20210910182454__Create_appliedprogramme_view $$
CREATE PROCEDURE V20210910182454__Create_appliedprogramme_view()
BEGIN
DROP VIEW IF EXISTS appliedprogramme_view;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='appliedprogramme_view')) THEN 
CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `appliedprogramme_view` AS
    SELECT DISTINCT
    
        `appl`.`code` AS `code`,
        `appl`.`id` AS `applicationid`,
        `prog`.`programCode` AS `programcode`,
        `ap`.`externalSysRefOne` AS `usnumber`,
        `ir`.`itemValue` AS `applicationYear`,
        `apro`.`currentStatus` AS `programmeOfferStatus`,
        `apro`.`offerLetterIssueDate` AS `programmeOfferDate`,
        `apro`.`currentStatus` AS `programmeAdmissionStatus`,
        `apro`.`offerLetterIssueDate` AS `programmeAdmissionDate`,
        `apro`.`currentStatus` AS `offerLetterStatus`,
        `dd`.`value` AS `eligibilityCheck`,
        `apro`.`priority` AS `programmePriority`,
        `appl`.`applicationCreatedOn` AS `applicationCreatedOn`,
        `appl`.`lastUpdate` AS `lastUpdate`,
        `t9`.`currentStatus` AS `STAGE_STATUS`,
        CAST(`apro`.`offerLetterAcceptanceDate` AS DATE) AS `OFFER_LETTER_ACCEPTANCE_DATE`
    FROM
        ((((((((`application_program` `apro`
        JOIN `application` `appl` ON ((`apro`.`applicationId` = `appl`.`id`)))
        JOIN `applicant_person` `ap` ON ((`appl`.`applicantPersonId` = `ap`.`id`)))
        JOIN `programs` `prog` ON ((`apro`.`programId` = `prog`.`id`)))
        LEFT JOIN `drop_down` `dd` ON ((`dd`.`id` = `apro`.`preEligibility`)))
        JOIN `batches` `btc` ON ((`btc`.`programId` = `prog`.`id`)))
        JOIN `intake_year` `ir` ON ((`btc`.`intakeYearId` = `ir`.`id`)))
        LEFT JOIN `program_slctn_process_stages` `t10` ON ((`t10`.`id` = `apro`.`currentStageId`)))
        LEFT JOIN `application_prog_stage` `t9` ON (((`t9`.`applicationProgramId` = `apro`.`id`)
            AND (`t9`.`programSelectionProcessStageId` = `t10`.`id`))));

END IF; 

END $$
CALL V20210910182454__Create_appliedprogramme_view () $$ 
DROP PROCEDURE IF EXISTS V20210910182454__Create_appliedprogramme_view $$ 
DELIMITER ;