DELIMITER //

DROP PROCEDURE IF EXISTS sp_tvet_staffdetails //
CREATE  PROCEDURE sp_tvet_staffdetails(in p_alid varchar(1000))
BEGIN

select per.nationalID as National_Id,
if ((char_length(per.nationalId)>0 && char_length(per.nationalId)<>13),per.nationalID ,usr.code) as Person_Alternate_Id,
if ((char_length(per.nationalId)>0 && char_length(per.nationalId)<>13),527,539) as Alternate_Id_Type_Id,
case when desg.itemCode is not null then desg.itemCode else 4 end as Staff_Type_Id,
usr.code as Staff_Number,
'' as Filler01,
case when staf.joiningDate is not null then DATE_FORMAT(staf.joiningDate, '%Y%m%d') else '20200101' end as Appointment_Date,
case when usr.status = 1 then null
when usr.status = 0 and staf.exitDate is not null then DATE_FORMAT(staf.exitDate, '%Y%m%d')
when usr.status = 0 and staf.exitDate is null then '20201031'
else null end  as Termination_Date,
case when usr.status = 1 then 1 when usr.status = 0  then 2 else null end Employment_Status_Id,
per.externalSysRefOne as Persal_Number,
loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id,
case when staf.facultyType='REGULAR' then 1 when staf.facultyType="VISITING" then 2 else 1 end as Appointment_Nature_Id,
case when staf.employeeType='FULL_TIME' then 1 when staf.employeeType='PART_TIME' then 2 else 1 end as Appointment_Type_Id,
2 as Remuneration_Id,
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp

from staffs staf  join persons per on(staf.personid=per.id)
left join
(select iddtla.idNumber,iddtla.personId,iddtla.itemCode from(
select idNumber,personId,idt.itemCode,row_number() OVER (PARTITION BY personId ORDER BY isnull(validTillDate) desc,validTillDate desc) rn
from identity_detail iddet join identity_type idt on(iddet.idType=idt.id and idt.itemCode='Passport')) iddtla where iddtla.rn=1)
iddetail on(iddetail.personId=per.id)
left join designations desg on(staf.designationId=desg.id)
left join users usr on(usr.id=staf.userid)
left join user_academy_locations alpur on(usr.id=alpur.userid)
left join academy_location al on(alpur.academyLocationId=al.id)
left join locations loc on(al.locationId=loc.id)
where usr.code not in
('SYSADMIN','PUBLIC_PORTAL_USER','APPLICANT_PORTAL_USER','ENQUIRY_PORTAL_USER','SSO_USER','MISAdmin','DUMMYFELTMANE','FBCADAMSDUMMY','serotracker')
and usr.status = 1 and FIND_IN_SET( al.id,p_alid)
group by alpur.id;

END//
DELIMITER ;