DELIMITER $$
DROP PROCEDURE IF EXISTS student_birthday_proc$$
CREATE PROCEDURE student_birthday_proc()
BEGIN

SELECT concat(persons.mobileCountryCode,persons.mobileNumber) as MobileNo , persons.firstName, academy_location.displayName, users.code
FROM students 
JOIN persons on students.personId = persons.Id
JOIN admission on students.userId = admission.studentId
JOIN academy_location on academy_location.id = admission.academyLocationId
JOIN users on users.id = students.userId
where DAY(persons.birthDate) = DAY(CURDATE()) and MONTH(persons.birthDate) = MONTH(CURDATE());

END $$
DELIMITER ;
