DELIMITER $$
DROP PROCEDURE IF EXISTS V20211214141626__Insert_BUZZ_IIE_MSA_STUDENT_ID_CARD $$
CREATE PROCEDURE V20211214141626__Insert_BUZZ_IIE_MSA_STUDENT_ID_CARD()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'BUZZ_IIE_MSA_STUDENT_ID_CARD')) THEN 

INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '7', 'BUZZ_IIE_MSA_STUDENT_ID_CARD', 'Buzz IIE MSA Student ID Card', 'id_card_front.png', 'CommonReport_IdCard_Horizontally.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'BUZZ_IIE_MSA_STUDENT_ID_CARD.jasper', 'AcademiaLogo.png');
END IF; 

set @BUZZ_IIE_MSA_STUDENT_ID_CARD = (select max(id) from report_template where templateCode ='BUZZ_IIE_MSA_STUDENT_ID_CARD');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD and keyValue='STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@BUZZ_IIE_MSA_STUDENT_ID_CARD, 'STUDENT_NAME', 'Student Name:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD and keyValue='STUDENT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@BUZZ_IIE_MSA_STUDENT_ID_CARD, 'STUDENT_NO', 'Student No:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD and keyValue='COURSE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@BUZZ_IIE_MSA_STUDENT_ID_CARD, 'COURSE_CODE', 'Course Code:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD and keyValue='CAMPUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@BUZZ_IIE_MSA_STUDENT_ID_CARD, 'CAMPUS', 'Campus:', '1', NOW());
END IF;

END $$
CALL V20211214141626__Insert_BUZZ_IIE_MSA_STUDENT_ID_CARD() $$
DROP PROCEDURE IF EXISTS V20211214141626__Insert_BUZZ_IIE_MSA_STUDENT_ID_CARD $$
DELIMITER ;