DELIMITER $$
DROP PROCEDURE IF EXISTS student_course_registration_reminder_whatsapp$$
CREATE PROCEDURE student_course_registration_reminder_whatsapp()
BEGIN
	
SELECT DISTINCT
    CONCAT(p.mobileCountryCode,p.mobileNumber) AS MOBILE_NO,
    T4.printName AS STUDENT_NAME,
    T11.itemValue AS REGISTRATION_TERM,
    T6.programNameToBePrint AS PROGRAM_NAME,
    T5.batchName AS BATCH_NAME,
    T7.printName AS PERIOD_NAME,
    DATE(T10.studentStartDateTime) AS TERM_STUDENT_START_DATE,
	DATE_FORMAT(T10.studentStartDateTime, '%h:%i %p') AS TERM_STUDENT_START_TIME,
    @@system_time_zone AS TIME_ZONE,
    DATE(T10.studentEndDateTime) AS TERM_STUDENT_END_DATE,
    DATE_FORMAT(T10.studentEndDateTime, '%h:%i %p') AS TERM_STUDENT_END_TIME,
    al.displayName as ACADEMY_LOCATION_NAME
FROM
    program_batch_students T1
        LEFT JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT JOIN
    users T4 ON T3.userId = T4.id
        LEFT JOIN
    batches T5 ON T1.programBatchId = T5.id
        LEFT JOIN
    programs T6 ON T5.programId = T6.id
        LEFT JOIN
    prog_batch_period_config T7 ON T1.progBatchPeriodConfigId = T7.id
        LEFT JOIN
    registration_term_setup_detail T9 ON T7.registrationTermSetupDetailId = T9.id
        LEFT JOIN
    term_wise_course_registration T10 ON T9.id = T10.registrationTermSetupDetailId
        LEFT JOIN
    registration_term T11 ON T10.registrationTermId = T11.id
        LEFT JOIN
    persons p ON p.id = T3.personId
    LEFT JOIN academy_location al ON al.id = T2.academyLocationId 
WHERE T1.isCurrentPeriod=1 AND T1.isCurrentSection=1 AND T1.exitDate is null AND 
    DATE(T10.studentStartDateTime) = DATE_FORMAT((DATE(NOW()) + INTERVAL 1 DAY),
            '%Y-%m-%d')
        AND T1.promotionEnrollmentStatus = 'PENDING'
GROUP BY T3.userId;

END $$
DELIMITER ;

