DELIMITER $$
DROP procedure IF EXISTS `student_finacial_summary_till_date`$$
DROP procedure IF EXISTS `student_receipt_till_date`$$

CREATE  PROCEDURE `student_finacial_summary_till_date`(IN studentIds VARCHAR(255))
BEGIN
DECLARE totalBill VARCHAR(255) DEFAULT 0;
DECLARE totalReceipt VARCHAR(255) DEFAULT 0;
DECLARE outstanding VARCHAR(255) DEFAULT 0;

SELECT
   CONCAT(c.currencyCode,' ',SUM(bfprs.billableAmount)) AS billableAmount INTO totalBill
FROM
    bill_fee_plan_rule_stage AS bfprs
        LEFT OUTER JOIN
    bill_header AS bh ON bh.id = bfprs.billId
        LEFT OUTER JOIN
    currency c ON bh.currencyId = c.id
WHERE
     FIND_IN_SET(bh.studentId, studentIds)
        AND bh.billStatus <> 'CANCELLED'
        AND bh.raiseBillCategory = 'BILL_RECEIVABLE'
GROUP BY bh.studentId;

SELECT 
    CONCAT(c.currencyCode,' ',SUM(bfprs.balanceAmount)) AS balanceAmount INTO outstanding
FROM
    bill_fee_plan_rule_stage AS bfprs
        LEFT OUTER JOIN
    bill_header AS bh ON bh.id = bfprs.billId
        LEFT OUTER JOIN
    currency c ON bh.currencyId = c.id
WHERE
    FIND_IN_SET(bh.studentId, studentIds)
        AND bh.billStatus <> 'CANCELLED'
        AND bh.raiseBillCategory = 'BILL_RECEIVABLE'
GROUP BY bh.studentId;

SELECT 
   
     CONCAT(c.currencyCode,' ',SUM(rh.amount)) AS receiptAmount INTO totalReceipt
FROM
    receipt_header AS rh
        LEFT OUTER JOIN
    currency AS c ON c.id = rh.currencyId
WHERE
    FIND_IN_SET(rh.studentId, studentIds)
        AND rh.status <> 'CANCELLED'
GROUP BY rh.studentId;

SELECT totalBill, totalReceipt,outstanding;

END$$
DELIMITER ;

