
DELIMITER $$
DROP TRIGGER IF EXISTS `document_types_after_insert` $$
DELIMITER ;

DELIMITER //

CREATE TRIGGER document_types_after_insert
AFTER INSERT
   ON document_types FOR EACH ROW
BEGIN
      -- Insert record into other table
    IF (NEW.itemCode = 'Education history-Marks Sheet') THEN  
    
     INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Documents', 'APPLICANT', NEW.id,
   'select T1.file_path AS value, "" AS code from applicant_education_histories T1 INNER JOIN  applicant_person T2 ON T2.id = T1.applicantPersonId 
where T1.whetherDeleted = false and T2.id = $param1',
'document.constant.temp.dir',NEW.lastUpdate,NEW.lastUpdatedBy);
    
    ELSEIF (NEW.itemCode = 'Post school studies- Certificate') THEN
    
    
     INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Documents', 'APPLICANT', NEW.id,
   'select T1.certificate_path AS value, "" AS code from post_school_studies_section T1 INNER JOIN  applicant_person T2 ON T2.id = T1.applicant_person_id 
where T2.id = $param1',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);
    
    ELSEIF (NEW.itemCode = 'Post school studies- Transcript') THEN
    
    
    INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Documents', 'APPLICANT', NEW.id,
   'select T1.transcript_path AS value, "" AS code from post_school_studies_section T1 INNER JOIN  applicant_person T2 ON T2.id = T1.applicant_person_id 
where T2.id = $param1',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);
    
    ELSE 
    
    INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('General',NEW.itemValue, 'Documents', 'APPLICANT', NEW.id,
   'select T3.path AS value, "" AS code from document_types T1 LEFT JOIN application_required_documents T2 ON T1.id = T2.documentTypeId 
LEFT JOIN documents T3 ON T3.id = T2.documentId LEFT JOIN application T4 ON T4.id = T2.applicationId
LEFT JOIN applicant_person T5 ON T5.id = T4.applicantPersonId where T4.applicantPersonId = $param1 and T1.itemValue = $param2',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);
	
	END IF;



 INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('General',NEW.itemValue, 'Documents', 'EMPLOYEE', NEW.id,
   'select T3.path AS value, "" AS code from document_types T1 
LEFT JOIN faculty_documents T2 ON T1.id = T2.documentTypeId 
LEFT JOIN documents T3 ON T3.id = T2.documentId LEFT JOIN users T4 ON T4.id = T2.facultyId
LEFT JOIN staffs T5 ON T5.userId = T4.id where T5.personId = $param1 and T1.itemValue = $param2',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);



IF (NEW.itemCode = 'Education history-Marks Sheet') THEN  

 INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Documents', 'STUDENT', NEW.id,
   'select T1.file_path AS value, "" AS code from education_histories T1 INNER JOIN  persons T2 ON T2.id = T1.personId 
where T1.whetherDeleted = false and T2.id = $param1',
'document.constant.temp.dir',NEW.lastUpdate,NEW.lastUpdatedBy);
    
   ELSEIF (NEW.itemCode = 'Post school studies- Certificate') THEN
    
    
     INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Documents', 'STUDENT', NEW.id,
   'select T1.certificate_path AS value, "" AS code from post_school_studies_section T1 INNER JOIN  persons T2 ON T2.id = T1.persons_id 
where T2.id = $param1',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);
    
    ELSEIF (NEW.itemCode = 'Post school studies- Transcript') THEN
    
    
    INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Documents', 'STUDENT', NEW.id,
   'select T1.transcript_path AS value, "" AS code from post_school_studies_section T1 INNER JOIN  persons T2 ON T2.id = T1.persons_id 
where T2.id = $param1',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);
    
    ELSE 
    INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('General',NEW.itemValue, 'Documents', 'STUDENT', NEW.id,
   'select T3.path AS value, "" AS code from document_types T1 LEFT JOIN student_documents T2 ON T1.id = T2.documentTypeId 
LEFT JOIN documents T3 ON T3.id = T2.documentId LEFT JOIN users T4 ON T4.id = T2.studentId
LEFT JOIN students T5 ON T5.userId = T4.id  where T5.personId = $param1 and T1.itemValue = $param2',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);
	
	END IF;


END; //

DELIMITER ; 
