DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_programsubjectdetails //
CREATE DEFINER=`ss_root`@`%` PROCEDURE `sp_tvet_programsubjectdetails`(in p_alid varchar(1000), in intakeYearId BIGINT)
BEGIN

SELECT DISTINCT
    p.programCode AS ProgrammeCode,
    cou.courseCode AS Subject_Code,
    MIN(DATE_FORMAT(b.startDate, '%Y%m%d')) AS Prog_Subj_Start_Date,
    CASE
        WHEN b.tillDate < NOW() THEN DATE_FORMAT(b.tillDate, '%Y%m%d')
        ELSE NULL
    END AS Prog_Subj_End_Date,
    al.locationCode AS Provider_Code,
    '541' Provider_ETQE_Id,
    CASE
        WHEN b.tillDate < NOW() THEN 2
        ELSE 1
    END AS Subject_Status_Id,
    CASE
        WHEN CAST(FLOOR(cou.courseCredits) AS UNSIGNED) = 0 THEN 10
        ELSE CAST(FLOOR(cou.courseCredits) AS UNSIGNED)
    END AS Subject_Credit,
    CASE
        WHEN cou.subjectTypeId IS NULL THEN 1 
        ELSE cou.subjectTypeId 
        END AS Prog_Subj_Type_Id,
    DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
FROM
    program_courses pc
        LEFT JOIN
    batches b ON (pc.programBatchId = b.id
        AND b.startDate < NOW()
        AND b.intakeYearId=intakeYearId)
        LEFT JOIN
    programs p ON b.programId = p.id
        LEFT JOIN
    academy_location al ON al.id = p.academyLocationId
        LEFT JOIN
    affiliated_university au ON au.id = p.affiliatedUniversityId
        LEFT JOIN
    prog_batch_period_config per ON per.programbatchId = b.id
        LEFT JOIN
    courses cou ON cou.id = pc.courseId
WHERE
    YEAR(NOW()) BETWEEN YEAR(b.startDate) AND YEAR(b.tillDate)
        AND al.locationCode <> 'FBC' and FIND_IN_SET( al.id,p_alid)

GROUP BY pc.courseId, p.id;

END//
DELIMITER ;